package ru.yandex.autotests.directapi.dynamictextadtargets.add.conditions;

import com.yandex.direct.api.v5.dynamictextadtargets.StringConditionOperatorEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageConditionOperandEnum;
import org.json.simple.JSONObject;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageConditionMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by ginger on 09.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.ADD)
public class AddConditionsJsonValidationTest {
    private static final String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT_ADD;
    private static Long pid;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    @Step("Подготовка данных для теста")
    public void createTestData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long cid = api.as(LOGIN).userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
    }

    @Test
    public void invalidFieldInConditions() {
        JSONObject request = new JSONObject();
        JSONObject dynamicTextAdTargets = new JSONObject();
        JSONObject conditions = new JSONObject();
        conditions.put(capitalize(WebpageConditionMap.OPERATOR), StringConditionOperatorEnum.NOT_CONTAINS_ALL);
        conditions.put(capitalize(WebpageConditionMap.OPERAND), WebpageConditionOperandEnum.DOMAIN);
        conditions.put(capitalize(WebpageConditionMap.ARGUMENTS), new Object[]{"asdasdasdasd.com"});
        conditions.put(capitalize(WebpageAddItemMap.AD_GROUP_ID), pid);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.AD_GROUP_ID), pid);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.NAME), WebpageAddItemMap.NAME);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.BID), 15000000);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.CONDITIONS), new Object[]{conditions});
        request.put(capitalize(AddRequestMap.WEBPAGES), new Object[]{dynamicTextAdTargets});
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAIN_UNKNOWN_FIELD,
                        path(capitalize(AddRequestMap.WEBPAGES), capitalize(WebpageAddItemMap.CONDITIONS)),
                        capitalize(WebpageAddItemMap.AD_GROUP_ID))
        );
    }


    @Test
    public void notArrayInConditions() {
        JSONObject request = new JSONObject();
        JSONObject dynamicTextAdTargets = new JSONObject();
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.AD_GROUP_ID), pid);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.NAME), WebpageAddItemMap.NAME);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.BID), 15000000f);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.CONDITIONS),
                new WebpageConditionMap()
                        .withOperand(WebpageConditionOperandEnum.DOMAIN)
                        .withOperator(StringConditionOperatorEnum.NOT_CONTAINS_ALL)
                        .withArguments("asdasdasdasd.com")
                        .getBean()
        );
        request.put(capitalize(AddRequestMap.WEBPAGES), new Object[]{dynamicTextAdTargets});
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(capitalize(AddRequestMap.WEBPAGES), capitalize(WebpageAddItemMap.CONDITIONS))));
    }


    @Test
    public void notArrayInArguments() {
        JSONObject request = new JSONObject();
        JSONObject dynamicTextAdTargets = new JSONObject();
        JSONObject conditions = new JSONObject();
        conditions.put(capitalize(WebpageConditionMap.OPERATOR), StringConditionOperatorEnum.NOT_CONTAINS_ALL);
        conditions.put(capitalize(WebpageConditionMap.OPERAND), WebpageConditionOperandEnum.DOMAIN);
        conditions.put(capitalize(WebpageConditionMap.ARGUMENTS), "asdasdasdasd.com");
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.AD_GROUP_ID), pid);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.NAME), WebpageAddItemMap.NAME);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.BID), 15000000f);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.CONDITIONS), new Object[]{conditions});
        request.put(capitalize(AddRequestMap.WEBPAGES), new Object[]{dynamicTextAdTargets});
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(capitalize(AddRequestMap.WEBPAGES), capitalize(WebpageAddItemMap.CONDITIONS),
                                capitalize(WebpageConditionMap.ARGUMENTS)))
        );
    }

    @Test
    public void arrayInOperator() {
        JSONObject request = new JSONObject();
        JSONObject dynamicTextAdTargets = new JSONObject();
        JSONObject conditions = new JSONObject();
        conditions.put(capitalize(WebpageConditionMap.OPERATOR),
                new Object[]{StringConditionOperatorEnum.NOT_CONTAINS_ALL});
        conditions.put(capitalize(WebpageConditionMap.OPERAND), WebpageConditionOperandEnum.DOMAIN);
        conditions.put(capitalize(WebpageConditionMap.ARGUMENTS), new Object[]{"asdasdasdasd.com"});
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.AD_GROUP_ID), pid);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.NAME), WebpageAddItemMap.NAME);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.BID), 15000000f);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.CONDITIONS), new Object[]{conditions});
        request.put(capitalize(AddRequestMap.WEBPAGES), new Object[]{dynamicTextAdTargets});
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(capitalize(AddRequestMap.WEBPAGES),
                                capitalize(WebpageAddItemMap.CONDITIONS),
                                capitalize(WebpageConditionMap.OPERATOR)))
        );
    }

    @Test
    public void arrayInOperand() {
        JSONObject request = new JSONObject();
        JSONObject dynamicTextAdTargets = new JSONObject();
        JSONObject conditions = new JSONObject();
        conditions.put(capitalize(WebpageConditionMap.OPERATOR), StringConditionOperatorEnum.NOT_CONTAINS_ALL);
        conditions.put(capitalize(WebpageConditionMap.OPERAND), new Object[]{WebpageConditionOperandEnum.DOMAIN});
        conditions.put(capitalize(WebpageConditionMap.ARGUMENTS), new Object[]{"asdasdasdasd.com"});
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.AD_GROUP_ID), pid);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.NAME), WebpageAddItemMap.NAME);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.BID), 15000000f);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.CONDITIONS), new Object[]{conditions});
        request.put(capitalize(AddRequestMap.WEBPAGES), new Object[]{dynamicTextAdTargets});
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(capitalize(AddRequestMap.WEBPAGES),
                                capitalize(WebpageAddItemMap.CONDITIONS),
                                capitalize(WebpageConditionMap.OPERAND))
                )
        );
    }
}
