package ru.yandex.autotests.directapi.dynamictextadtargets.add.conditions;

import com.yandex.direct.api.v5.dynamictextadtargets.StringConditionOperatorEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageConditionOperandEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageConditionMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static com.sun.xml.ws.util.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by ginger on 09.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.ADD)
public class AddConditionsMandatoryFieldsTest {
    private static final String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long pid;

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign(LOGIN);
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
    }

    @Test
    @Description("Запрос без поля Operand в запросе на добавление условий нацеливания")
    public void requestWithoutOperand() {
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsAdd(
                new AddRequestMap()
                        .withWebpages(
                                new WebpageAddItemMap()
                                        .withName("Name1")
                                        .withBid(30000000l)
                                        .withAdGroupId(pid)
                                        .withConditions(
                                                new WebpageConditionMap()
                                                        .withArguments("ginger")
                                                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                                        )),
                new Api5Error(8000, Api5ErrorDetailsJava.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        path(capitalize(AddRequestMap.WEBPAGES),
                                capitalize(WebpageAddItemMap.CONDITIONS)), capitalize(WebpageConditionMap.OPERAND)));
    }

    @Test
    @Description("Запрос без поля Operator в запросе на добавление условия нацеливания")
    public void requestWithoutOperator() {
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsAdd(
                new AddRequestMap()
                        .withWebpages(
                                new WebpageAddItemMap()
                                        .withName("Name1")
                                        .withBid(30000000l)
                                        .withAdGroupId(pid)
                                        .withConditions(
                                                new WebpageConditionMap()
                                                        .withArguments("ginger")
                                                        .withOperand(WebpageConditionOperandEnum.PAGE_TITLE)
                                        )),
                new Api5Error(8000, Api5ErrorDetailsJava.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        path(capitalize(AddRequestMap.WEBPAGES),
                                capitalize(WebpageAddItemMap.CONDITIONS)), capitalize(WebpageConditionMap.OPERATOR)));
    }


    @Test
    @Description("Запрос без поля Arguments в запросе на добавление условия нацеливания")
    public void requestWithoutArguments() {
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsAdd(
                new AddRequestMap()
                        .withWebpages(
                                new WebpageAddItemMap()
                                        .withName("Name1")
                                        .withBid(30000000l)
                                        .withAdGroupId(pid)
                                        .withConditions(
                                                new WebpageConditionMap()
                                                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                                                        .withOperand(WebpageConditionOperandEnum.PAGE_TITLE)
                                        )),
                new Api5Error(8000, Api5ErrorDetailsJava.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        path(capitalize(AddRequestMap.WEBPAGES),
                                capitalize(WebpageAddItemMap.CONDITIONS)), capitalize(WebpageConditionMap.ARGUMENTS)));
    }
}
