package ru.yandex.autotests.directapi.dynamictextadtargets.add.conditions;

import java.util.Arrays;

import com.yandex.direct.api.v5.dynamictextadtargets.StringConditionOperatorEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageConditionOperandEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageConditionMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qa.balance.tools.common.utils.RandomDataUtils;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 09.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.ADD)
public class AddConditionsNegativeTest {
    private static final String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT_ADD;
    private static Long pid;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);


    @Before
    @Step("Подготовка данных для теста")
    public void createTestData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long cid = api.as(LOGIN).userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
    }

    @Test
    public void tryAddPageTitleWithEqualsAnyOperator() {
        JavaOrPerlExpectedResult expectedResult = JavaOrPerlExpectedResult
                .java(ExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetails.INVALID_FORMAT_WEBPAGE_CONDITION, 1)
                                .withDetails("Неправильный формат правила №1: задано неподдерживаемое отношение")))
                .perl(ExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetails.INVALID_FORMAT_WEBPAGE_CONDITION, 1)));
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(
                                new WebpageAddItemMap()
                                        .withConditions(
                                                new WebpageConditionMap()
                                                        .withOperand(WebpageConditionOperandEnum.PAGE_TITLE)
                                                        .withOperator(StringConditionOperatorEnum.EQUALS_ANY)
                                                        .withArguments(RandomDataUtils.getRandomString(10))
                                        )
                                        .withName("Name1")
                                        .withBid(30000000l)
                                        .withAdGroupId(pid)
                        ),
                expectedResult
        );
    }

    @Test
    public void tryAddPageTitleWithNotEqualsAnyOperator() {
        JavaOrPerlExpectedResult expectedResult = JavaOrPerlExpectedResult
                .java(ExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetails.INVALID_FORMAT_WEBPAGE_CONDITION, 1)
                                .withDetails("Неправильный формат правила №1: задано неподдерживаемое отношение")))
                .perl(ExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetails.INVALID_FORMAT_WEBPAGE_CONDITION, 1)));

        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(
                                new WebpageAddItemMap()
                                        .withConditions(
                                                new WebpageConditionMap()
                                                        .withOperand(WebpageConditionOperandEnum.PAGE_TITLE)
                                                        .withOperator(StringConditionOperatorEnum.NOT_EQUALS_ALL)
                                                        .withArguments(RandomDataUtils.getRandomString(10))
                                        )
                                        .withName("Name1")
                                        .withBid(30000000l)
                                        .withAdGroupId(pid)
                        ),
                expectedResult
        );
    }


    @Test
    public void tryAddPageContentWithEqualsAnyOperator() {
        JavaOrPerlExpectedResult expectedResult = JavaOrPerlExpectedResult
                .java(ExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetails.INVALID_FORMAT_WEBPAGE_CONDITION, 1)
                                .withDetails("Неправильный формат правила №1: задано неподдерживаемое отношение")))
                .perl(ExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetails.INVALID_FORMAT_WEBPAGE_CONDITION, 1)));
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(
                                new WebpageAddItemMap()
                                        .withConditions(
                                                new WebpageConditionMap()
                                                        .withOperand(WebpageConditionOperandEnum.PAGE_CONTENT)
                                                        .withOperator(StringConditionOperatorEnum.EQUALS_ANY)
                                                        .withArguments(RandomDataUtils.getRandomString(10))
                                        )
                                        .withName("Name1")
                                        .withBid(30000000l)
                                        .withAdGroupId(pid)
                        ),
                expectedResult
        );
    }

    @Test
    public void tryAddPageContentWithNotEqualsAnyOperator() {
        JavaOrPerlExpectedResult expectedResult = JavaOrPerlExpectedResult
                .java(ExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetails.INVALID_FORMAT_WEBPAGE_CONDITION, 1)
                                .withDetails("Неправильный формат правила №1: задано неподдерживаемое отношение")))
                .perl(ExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetails.INVALID_FORMAT_WEBPAGE_CONDITION, 1)));

        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(
                                new WebpageAddItemMap()
                                        .withConditions(
                                                new WebpageConditionMap()
                                                        .withOperand(WebpageConditionOperandEnum.PAGE_CONTENT)
                                                        .withOperator(StringConditionOperatorEnum.NOT_EQUALS_ALL)
                                                        .withArguments(RandomDataUtils.getRandomString(10))
                                        )
                                        .withName("Name1")
                                        .withBid(30000000l)
                                        .withAdGroupId(pid)
                        ),
                expectedResult
        );
    }


    @Test
    public void tryAddUrlWithEqualsAnyOperator() {
        JavaOrPerlExpectedResult expectedResult = JavaOrPerlExpectedResult
                .java(ExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetails.INVALID_FORMAT_WEBPAGE_CONDITION, 1)
                                .withDetails("Неправильный формат правила №1: задано неподдерживаемое отношение")))
                .perl(ExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetails.INVALID_FORMAT_WEBPAGE_CONDITION, 1)));
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(
                                new WebpageAddItemMap()
                                        .withConditions(
                                                new WebpageConditionMap()
                                                        .withOperand(WebpageConditionOperandEnum.URL)
                                                        .withOperator(StringConditionOperatorEnum.EQUALS_ANY)
                                                        .withArguments("https://" + RandomDataUtils.getRandomString(10) + ".com")
                                        )
                                        .withName("Name1")
                                        .withBid(30000000l)
                                        .withAdGroupId(pid)
                        ),
                expectedResult
        );
    }

    @Test
    public void tryAddUrlWithNotEqualsAllOperator() {
        JavaOrPerlExpectedResult expectedResult = JavaOrPerlExpectedResult
                .java(ExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetails.INVALID_FORMAT_WEBPAGE_CONDITION, 1)
                                .withDetails("Неправильный формат правила №1: задано неподдерживаемое отношение"))
                )
                .perl(ExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetails.INVALID_FORMAT_WEBPAGE_CONDITION, 1))
                );
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(
                                new WebpageAddItemMap()
                                        .withConditions(
                                                new WebpageConditionMap()
                                                        .withOperand(WebpageConditionOperandEnum.URL)
                                                        .withOperator(StringConditionOperatorEnum.NOT_EQUALS_ALL)
                                                        .withArguments("https://" + RandomDataUtils.getRandomString(10) + ".com")
                                        )
                                        .withName("Name1")
                                        .withBid(30000000l)
                                        .withAdGroupId(pid)
                        ),
                expectedResult);
    }


    @Test
    public void tryAddOffersListWithContainsAnyOperator() {
        JavaOrPerlExpectedResult expectedResult = JavaOrPerlExpectedResult
                .java(ExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetails.INVALID_FORMAT_WEBPAGE_CONDITION, 1)
                                .withDetails("Неправильный формат правила №1: задано неподдерживаемое отношение")))
                .perl(ExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetails.INVALID_FORMAT_WEBPAGE_CONDITION, 1)));
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(
                                new WebpageAddItemMap()
                                        .withConditions(
                                                new WebpageConditionMap()
                                                        .withOperand(WebpageConditionOperandEnum.OFFERS_LIST_URL)
                                                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                                                        .withArguments("https://" + RandomDataUtils.getRandomString(10) + ".com")
                                        )
                                        .withName("Name1")
                                        .withBid(30000000l)
                                        .withAdGroupId(pid)
                        ),
                expectedResult
        );
    }

    @Test
    public void tryAddOffersListWithNotContainsAllOperator() {

        JavaOrPerlExpectedResult expectedResult = JavaOrPerlExpectedResult
                .java(ExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetails.INVALID_FORMAT_WEBPAGE_CONDITION, 1)
                                .withDetails("Неправильный формат правила №1: задано неподдерживаемое отношение"))
                )
                .perl(ExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetails.INVALID_FORMAT_WEBPAGE_CONDITION, 1))
                );

        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(
                                new WebpageAddItemMap()
                                        .withConditions(
                                                new WebpageConditionMap()
                                                        .withOperand(WebpageConditionOperandEnum.OFFERS_LIST_URL)
                                                        .withOperator(StringConditionOperatorEnum.NOT_CONTAINS_ALL)
                                                        .withArguments("https://" + RandomDataUtils.getRandomString(10) + ".com")
                                        )
                                        .withName("Name1")
                                        .withBid(30000000l)
                                        .withAdGroupId(pid)
                        ),
                expectedResult);
    }


    @Test
    public void tryAddDomainWithEqualsAnyOperator() {
        JavaOrPerlExpectedResult expectedResult = JavaOrPerlExpectedResult
                .java(ExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetails.INVALID_FORMAT_WEBPAGE_CONDITION, 1)
                                .withDetails("Неправильный формат правила №1: задано неподдерживаемое отношение")))
                .perl(ExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetails.INVALID_FORMAT_WEBPAGE_CONDITION, 1)));
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(
                                new WebpageAddItemMap()
                                        .withConditions(
                                                new WebpageConditionMap()
                                                        .withOperand(WebpageConditionOperandEnum.DOMAIN)
                                                        .withOperator(StringConditionOperatorEnum.EQUALS_ANY)
                                                        .withArguments(RandomDataUtils.getRandomString(10))
                                        )
                                        .withName("Name1")
                                        .withBid(30000000l)
                                        .withAdGroupId(pid)
                        ),
                expectedResult
        );
    }

    @Test
    public void tryAddDomainWithNotEqualsAllOperator() {
        JavaOrPerlExpectedResult expectedResult = JavaOrPerlExpectedResult
                .java(ExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetails.INVALID_FORMAT_WEBPAGE_CONDITION, 1)
                                .withDetails("Неправильный формат правила №1: задано неподдерживаемое отношение")))
                .perl(ExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetails.INVALID_FORMAT_WEBPAGE_CONDITION, 1)));
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(
                                new WebpageAddItemMap()
                                        .withConditions(
                                                new WebpageConditionMap()
                                                        .withOperand(WebpageConditionOperandEnum.DOMAIN)
                                                        .withOperator(StringConditionOperatorEnum.NOT_EQUALS_ALL)
                                                        .withArguments(RandomDataUtils.getRandomString(10))
                                        )
                                        .withName("Name1")
                                        .withBid(30000000l)
                                        .withAdGroupId(pid)
                        ),
                expectedResult
        );
    }


    @Test
    @Description("Добавить несколько одинаковых условий нацеливаний за один запрос")
    public void addSomeSameConditionsWithOneRequest() {
        WebpageConditionMap[] conditionMaps = new WebpageConditionMap[10];
        Arrays.fill(conditionMaps, new WebpageConditionMap()
                .withOperand(WebpageConditionOperandEnum.PAGE_TITLE)
                .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                .withArguments("ginger")
        );
        ExpectedResult[] expectedResults = new ExpectedResult[4];
        Arrays.fill(expectedResults, ExpectedResult.errors(
                new Notification(8800, Api5ErrorDetails.NULL_STRING)));

        JavaOrPerlExpectedResult expectedResult = JavaOrPerlExpectedResult
                .java(ExpectedResult.errors(new Notification(9800, Api5ErrorDetails.RULES_IN_CONDITION_MUST_BE_UNIQUE)
                        .withDetails("Правила в условии нацеливания должны быть уникальны")))
                .perl(ExpectedResult.errors(new Notification(9800,
                        Api5ErrorDetails.RULES_IN_CONDITION_MUST_BE_UNIQUE)));

        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(
                                new WebpageAddItemMap()
                                        .withConditions(conditionMaps)
                                        .withName("Name1")
                                        .withBid(30000000l)
                                        .withAdGroupId(pid)
                        ),
                expectedResult
        );
    }

}
