package ru.yandex.autotests.directapi.dynamictextadtargets.add.conditions;

import com.yandex.direct.api.v5.dynamictextadtargets.AddResponse;
import com.yandex.direct.api.v5.dynamictextadtargets.GetResponse;
import com.yandex.direct.api.v5.dynamictextadtargets.StringConditionOperatorEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageConditionOperandEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageFieldEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageTypeEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageConditionMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpagesSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qa.balance.tools.common.utils.RandomDataUtils;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;

/**
 * Created by ginger on 09.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.ADD)
public class AddConditionsTest {
    private static final String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT_ADD;
    private static int shard;
    private static Long pid;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createTestData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long cid = api.as(LOGIN).userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
    }

    @Test
    public void addPageTitleWithContainsAnyOperator() {
        AddResponse response = api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(
                                new WebpageAddItemMap()
                                        .withConditions(
                                                new WebpageConditionMap()
                                                        .withOperand(WebpageConditionOperandEnum.PAGE_TITLE)
                                                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                                                        .withArguments(RandomDataUtils.getRandomString(10))
                                        )
                                        .withName("Name1")
                                        .withBid(30000000l)
                                        .withAdGroupId(pid)
                        ),
                ExpectedResult.success()
        );
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .dynamicConditionsSteps()
                .getDynamicConditions(response.getAddResults().get(0).getId());
    }

    @Test
    public void addPageTitleWithNotContainsAllOperator() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(
                                new WebpageAddItemMap()
                                        .withConditions(
                                                new WebpageConditionMap()
                                                        .withOperand(WebpageConditionOperandEnum.PAGE_TITLE)
                                                        .withOperator(StringConditionOperatorEnum.NOT_CONTAINS_ALL)
                                                        .withArguments(RandomDataUtils.getRandomString(10))
                                        )
                                        .withName("Name1")
                                        .withBid(30000000l)
                                        .withAdGroupId(pid)
                        ),
                ExpectedResult.success()
        );
    }


    @Test
    public void addPageContentWithContainsAnyOperator() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(
                                new WebpageAddItemMap()
                                        .withConditions(
                                                new WebpageConditionMap()
                                                        .withOperand(WebpageConditionOperandEnum.PAGE_CONTENT)
                                                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                                                        .withArguments(RandomDataUtils.getRandomString(10))
                                        )
                                        .withName("Name1")
                                        .withBid(30000000l)
                                        .withAdGroupId(pid)
                        ),
                ExpectedResult.success()
        );
    }

    @Test
    public void addPageContentWithNotContainsAllOperator() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(
                                new WebpageAddItemMap()
                                        .withConditions(
                                                new WebpageConditionMap()
                                                        .withOperand(WebpageConditionOperandEnum.PAGE_CONTENT)
                                                        .withOperator(StringConditionOperatorEnum.NOT_CONTAINS_ALL)
                                                        .withArguments(RandomDataUtils.getRandomString(10))
                                        )
                                        .withName("Name1")
                                        .withBid(30000000l)
                                        .withAdGroupId(pid)
                        ),
                ExpectedResult.success()
        );
    }


    @Test
    public void addUrlWithContainsAnyOperator() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(
                                new WebpageAddItemMap()
                                        .withConditions(
                                                new WebpageConditionMap()
                                                        .withOperand(WebpageConditionOperandEnum.URL)
                                                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                                                        .withArguments(RandomDataUtils.getRandomString(10))
                                        )
                                        .withName("Name1")
                                        .withBid(30000000l)
                                        .withAdGroupId(pid)
                        ),
                ExpectedResult.success()
        );
    }

    @Test
    public void addUrlWithNotContainsAllOperator() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(
                                new WebpageAddItemMap()
                                        .withConditions(
                                                new WebpageConditionMap()
                                                        .withOperand(WebpageConditionOperandEnum.URL)
                                                        .withOperator(StringConditionOperatorEnum.NOT_CONTAINS_ALL)
                                                        .withArguments(RandomDataUtils.getRandomString(10))
                                        )
                                        .withName("Name1")
                                        .withBid(30000000l)
                                        .withAdGroupId(pid)
                        ),
                ExpectedResult.success()
        );
    }


    @Test
    public void addOffersListWithEqualsAnyOperator() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(
                                new WebpageAddItemMap()
                                        .withConditions(
                                                new WebpageConditionMap()
                                                        .withOperand(WebpageConditionOperandEnum.OFFERS_LIST_URL)
                                                        .withOperator(StringConditionOperatorEnum.EQUALS_ANY)
                                                        .withArguments("https://"+RandomDataUtils.getRandomString(10)+".com")
                                        )
                                        .withName("Name1")
                                        .withBid(30000000l)
                                        .withAdGroupId(pid)
                        ),
                ExpectedResult.success()
        );
    }

    @Test
    public void addOffersListWithNotEqualsAllOperator() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(
                                new WebpageAddItemMap()
                                        .withConditions(
                                                new WebpageConditionMap()
                                                        .withOperand(WebpageConditionOperandEnum.OFFERS_LIST_URL)
                                                        .withOperator(StringConditionOperatorEnum.NOT_EQUALS_ALL)
                                                        .withArguments("https://"+RandomDataUtils.getRandomString(10)+".com")
                                        )
                                        .withName("Name1")
                                        .withBid(30000000l)
                                        .withAdGroupId(pid)
                        ),
                ExpectedResult.success()
        );
    }


    @Test
    public void addDomainWithContainsAnyOperator() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(
                                new WebpageAddItemMap()
                                        .withConditions(
                                                new WebpageConditionMap()
                                                        .withOperand(WebpageConditionOperandEnum.DOMAIN)
                                                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                                                        .withArguments(RandomDataUtils.getRandomString(10))
                                        )
                                        .withName("Name1")
                                        .withBid(30000000l)
                                        .withAdGroupId(pid)
                        ),
                ExpectedResult.success()
        );
    }

    @Test
    public void addDomainWithNotContainsAllOperator() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(
                                new WebpageAddItemMap()
                                        .withConditions(
                                                new WebpageConditionMap()
                                                        .withOperand(WebpageConditionOperandEnum.DOMAIN)
                                                        .withOperator(StringConditionOperatorEnum.NOT_CONTAINS_ALL)
                                                        .withArguments(RandomDataUtils.getRandomString(10))
                                        )
                                        .withName("Name1")
                                        .withBid(30000000l)
                                        .withAdGroupId(pid)
                        ),
                ExpectedResult.success()
        );
    }

    @Test
    public void addDefaultCondition(){
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(
                                new WebpageAddItemMap()
                                        .withName("Name1")
                                        .withAdGroupId(pid)
                        ),
                ExpectedResult.success()
        );
        GetResponse response = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap()
                        .withFieldNames(WebpageFieldEnum.CONDITION_TYPE)
                        .withSelectionCriteria(new WebpagesSelectionCriteriaMap().withAdGroupIds(pid)));
        assertThat("вернулось верное знаяени Condition о умолчанию",
                response.getWebpages().get(0).getConditionType(),
                equalTo(WebpageTypeEnum.PAGES_ALL));
    }
}
