package ru.yandex.autotests.directapi.dynamictextadtargets.add.conditions;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.dynamictextadtargets.StringConditionOperatorEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageConditionOperandEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageConditionMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qa.balance.tools.common.utils.RandomDataUtils;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

/**
 * Created by ginger on 26.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.ADD)
@RunWith(Parameterized.class)
public class AddUrlAndOffersListUrlNegativeTest {
    private static String client = DynamicTextAdTargetsLogins.SINGLE_CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    private static Long pid;
    private static Long cid;

    @Rule
    public Trashman trashman = new Trashman(api);
    @Parameterized.Parameter()
    public String description;

    @Parameterized.Parameter(1)
    public WebpageConditionOperandEnum operand;

    @Parameterized.Parameter(2)
    public StringConditionOperatorEnum operator;

    @Parameterized.Parameter(3)
    public String[] arguments;

    @Parameterized.Parameter(4)
    public JavaOrPerlExpectedResult expectedResults;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        String wrongProtocolUrl = "ssh://ginger.com";
        String urlWithSpecificSymbol = "https://ムラrld.ru";
        String greaterThanMaxLengthUrlForOffersList =
                "http://" + RandomDataUtils
                        .getRandomString(WebpageConditionMap.MAX_LENGTH_OF_OFFERS_LIST_URL_ARGUMENT - 6);
        String greaterThanMaxLengthUrlForOtherOperand =
                "http://" + RandomDataUtils
                        .getRandomString(WebpageConditionMap.MAX_LENGTH_OF_OTHER_OPERAND_ARGUMENT - 6);
        String[] greaterThanMaxAmountOfArguments = new String[WebpageConditionMap.MAX_ARGUMENTS_AMOUNT + 1];
        Arrays.fill(greaterThanMaxAmountOfArguments, RandomDataUtils.getRandomString(10));
        return Arrays.asList(new Object[][]{
                {"Создать правило для OFFERS_LIST_URL с аргументом, протокол которого отличен от http или https",
                        WebpageConditionOperandEnum.OFFERS_LIST_URL, StringConditionOperatorEnum.EQUALS_ANY,
                        new String[]{wrongProtocolUrl},
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult
                                        .errors(new Notification(5004, Api5ErrorDetails.INVALID_FORMAT_CONDITION_URL,
                                                1, 1)
                                                .withDetails("Неправильный формат ссылки №1 для правила №1")))
                                .perl(ExpectedResult
                                .errors(new Notification(5004, Api5ErrorDetails.INVALID_FORMAT_CONDITION_URL, 1, 1)))},
                {"Создать правило для URL с аргументом содержащим специфичный символ",
                        WebpageConditionOperandEnum.URL, StringConditionOperatorEnum.NOT_CONTAINS_ALL,
                        new String[]{urlWithSpecificSymbol},
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult
                                        .errors(new Notification(5002,
                                                Api5ErrorDetails.IN_CONDITION_ALLOWED_TO_USE_LETTERS, 1,
                                                1).withDetails("В значении №1 правила №1 допускается использование " +
                                                "букв латинского, турецкого, русского, украинского, казахского " +
                                                "алфавитов, цифр и знаков пунктуации.")))
                                .perl(ExpectedResult
                                .errors(new Notification(5002, Api5ErrorDetails.IN_CONDITION_ALLOWED_TO_USE_LETTERS, 1,
                                        1)))},
                {"Создать правило для OFFERS_LIST_URL с аргументом содержащим специфичный символ",
                        WebpageConditionOperandEnum.OFFERS_LIST_URL, StringConditionOperatorEnum.NOT_EQUALS_ALL,
                        new String[]{urlWithSpecificSymbol},
                        JavaOrPerlExpectedResult.java(ExpectedResult
                                .errors(new Notification(5002, Api5ErrorDetails.IN_CONDITION_ALLOWED_TO_USE_LETTERS, 1,
                                        1)
                                        .withDetails("В значении №1 правила №1 допускается использование букв " +
                                                "латинского, турецкого, русского, украинского, казахского алфавитов, " +
                                                "цифр и знаков пунктуации.")))
                                .perl(ExpectedResult
                                .errors(new Notification(5004, Api5ErrorDetails.INVALID_FORMAT_CONDITION_URL, 1, 1),
                                        new Notification(5002, Api5ErrorDetails.IN_CONDITION_ALLOWED_TO_USE_LETTERS, 1,
                                                1)))},
                {
                        "Создать правило для URL с аргументом содержащим сслыку, длина которой больше максимальной",
                        WebpageConditionOperandEnum.URL, StringConditionOperatorEnum.CONTAINS_ANY,
                        new String[]{greaterThanMaxLengthUrlForOtherOperand},
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult
                                        .errors(new Notification(5001,
                                                Api5ErrorDetails.EXCEEDED_MAX_LENGTH_IN_ARGUMENTS, 1, 1,
                                                100)
                                                .withDetails("Превышена максимальная длина значения №1 правила №1 в " +
                                                        "100 символов")))
                                .perl(ExpectedResult
                                .errors(new Notification(5001, Api5ErrorDetails.EXCEEDED_MAX_LENGTH_IN_ARGUMENTS, 1, 1,
                                        100)))
                },
                {
                        "Создать правило для OFFERS_LIST_URL с аргументом содержащим сслыку, длина которой больше " +
                                "максимальной",
                        WebpageConditionOperandEnum.OFFERS_LIST_URL, StringConditionOperatorEnum.EQUALS_ANY,
                        new String[]{greaterThanMaxLengthUrlForOffersList},
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult
                                        .errors(new Notification(5001,
                                                        Api5ErrorDetails.EXCEEDED_MAX_LENGTH_IN_ARGUMENTS, 1, 1,
                                                        1024)
                                                        .withDetails("Превышена максимальная длина значения №1 " +
                                                                "правила №1 в 1024 символов"),
                                                new Notification(5004, Api5ErrorDetails.INVALID_FORMAT_CONDITION_URL,
                                                        1, 1)
                                                        .withDetails("Неправильный формат ссылки №1 для правила №1")))
                                .perl(ExpectedResult
                                .errors(new Notification(5001, Api5ErrorDetails.EXCEEDED_MAX_LENGTH_IN_ARGUMENTS, 1, 1,
                                                1024),
                                        new Notification(5004, Api5ErrorDetails.INVALID_FORMAT_CONDITION_URL, 1, 1)))
                },
                {
                        "Создать правило для URL с кол-вом аргументов больше максимального",
                        WebpageConditionOperandEnum.URL, StringConditionOperatorEnum.CONTAINS_ANY,
                        greaterThanMaxAmountOfArguments,
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult
                                        .errors(new Notification(7000,
                                                Api5ErrorDetails.NUMBER_OF_ARGUMENTS_MUST_BE_FROM_TO, 1,
                                                1, 10)
                                                .withDetails("Количество аргументов в правиле  №1 условия нацеливания" +
                                                        " должно быть от 1 до 10")))
                                .perl(ExpectedResult
                                .errors(new Notification(7000, Api5ErrorDetails.NUMBER_OF_ARGUMENTS_MUST_BE_FROM_TO, 1,
                                        1, 10)))
                },
                {
                        "Создать правило для OFFERS_LIST_URL с аргументом = пустой строке",
                        WebpageConditionOperandEnum.OFFERS_LIST_URL, StringConditionOperatorEnum.EQUALS_ANY,
                        new String[]{""},
                        JavaOrPerlExpectedResult.java(ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.VALUE_OF_RULE_MUST_CONTAIN_SIGNIFICANT_CHARACTERS, 1, 1)
                                .withDetails("Неправильный формат правила: значение №1 правила №1 должно содержать хотя бы один значащий символ")))
                                .perl(
                                ExpectedResult.errors(new Notification(5005,
                                        Api5ErrorDetails.INCORRECT_RULE_FORMAT_EMPTY_ARGUMENT, 1, 1)))
                },
                {
                        "Создать правило для URL с аргументом = нескольким пробелам",
                        WebpageConditionOperandEnum.URL, StringConditionOperatorEnum.CONTAINS_ANY,
                        new String[]{"   "},
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(new Notification(5005,
                                        Api5ErrorDetails.VALUE_OF_RULE_MUST_CONTAIN_SIGNIFICANT_CHARACTERS, 1, 1)
                                        .withDetails("Неправильный формат правила: значение №1 правила №1 должно " +
                                                "содержать хотя бы один значащий символ")))
                                .perl(ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.VALUE_OF_RULE_MUST_CONTAIN_SIGNIFICANT_CHARACTERS, 1, 1)))},
        });
    }

    @BeforeClass
    public static void initTest() {
        cid = api.as(client).userSteps.campaignSteps().addDefaultDynamicTextCampaign();
    }

    @Before
    public void createGroup() {
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        api.as(client);
    }

    @Test
    public void addWithInvalidArguments() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.AddRequestMap()
                        .withWebpages(new WebpageAddItemMap()
                                .withAdGroupId(pid)
                                .withName("Name")
                                .withConditions(
                                        new WebpageConditionMap()
                                                .withOperator(operator)
                                                .withArguments(arguments)
                                                .withOperand(operand)
                                )
                                .withBid(30000000L)
                        ),
                expectedResults
        );
    }
}
