package ru.yandex.autotests.directapi.dynamictextadtargets.add.conditions;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.dynamictextadtargets.StringConditionOperatorEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageConditionOperandEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageConditionMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qa.balance.tools.common.utils.RandomDataUtils;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphabetic;

/**
 * Created by ginger on 26.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.ADD)
@RunWith(Parameterized.class)
public class AddUrlAndOffersListUrlPositiveTest {
    private static String client = DynamicTextAdTargetsLogins.SINGLE_CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    private static Long pid;
    private static Long cid;

    @Rule
    public Trashman trashman = new Trashman(api);
    @Parameterized.Parameter()
    public String description;

    @Parameterized.Parameter(1)
    public WebpageConditionOperandEnum operand;

    @Parameterized.Parameter(2)
    public StringConditionOperatorEnum operator;

    @Parameterized.Parameter(3)
    public String[] arguments;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        String httpUrl = "http://yandex.ru";
        String httpsUrl = "https://ya.ru";
        String russianUrl = "http://подарки.рф";
        String ukrainianUrl = "http://сувеніри.укр";
        String numericUrl = "http://12345.b45";
        String dashedUrl = "http://hello-world.ru";
        String maxLengthUrlForOffersList =
                "http://" + generateValidHrefWithoutProtocolOfLength(
                        WebpageConditionMap.MAX_LENGTH_OF_OFFERS_LIST_URL_ARGUMENT - 7);
        String maxLengthUrlForOtherOperand =
                "http://" + generateValidHrefWithoutProtocolOfLength(
                        WebpageConditionMap.MAX_LENGTH_OF_OTHER_OPERAND_ARGUMENT - 7);
        String[] maxAmountOfArguments = new String[WebpageConditionMap.MAX_ARGUMENTS_AMOUNT];
        Arrays.fill(maxAmountOfArguments, "https://" + RandomDataUtils.getRandomString(5) + ".ru");

        return Arrays.asList(new Object[][]{
                {"Создать правило(URL) со ссылкой, протокол которой http", WebpageConditionOperandEnum.URL,
                        StringConditionOperatorEnum.CONTAINS_ANY, new String[]{httpUrl}},
                {"Создать правило(URL) со ссылкой, протокол которой https", WebpageConditionOperandEnum.URL,
                        StringConditionOperatorEnum.CONTAINS_ANY, new String[]{httpsUrl}},
                {"Создать правило(URL) со ссылкой, состоящей из русских букв", WebpageConditionOperandEnum.URL,
                        StringConditionOperatorEnum.CONTAINS_ANY, new String[]{russianUrl}},
                {"Создать правило(URL) со ссылкой, состоящей из украинских букв", WebpageConditionOperandEnum.URL,
                        StringConditionOperatorEnum.CONTAINS_ANY, new String[]{ukrainianUrl}},
                {"Создать правило(URL) со ссылкой, содержащей цифры", WebpageConditionOperandEnum.URL,
                        StringConditionOperatorEnum.CONTAINS_ANY, new String[]{numericUrl}},
                {"Создать правило(URL) со ссылкой, содержащей дефисы", WebpageConditionOperandEnum.URL,
                        StringConditionOperatorEnum.CONTAINS_ANY, new String[]{dashedUrl}},
                {"Создать правило(URL) со ссылкой, длиной " + WebpageConditionMap.MAX_LENGTH_OF_OTHER_OPERAND_ARGUMENT,
                        WebpageConditionOperandEnum.URL, StringConditionOperatorEnum.CONTAINS_ANY,
                        new String[]{maxLengthUrlForOtherOperand}},
                {"Создать правило(OFFERS_LIST_URL) со ссылкой, протокол которой http",
                        WebpageConditionOperandEnum.OFFERS_LIST_URL,
                        StringConditionOperatorEnum.EQUALS_ANY, new String[]{httpUrl}},
                {"Создать правило(OFFERS_LIST_URL) со ссылкой, протокол которой https",
                        WebpageConditionOperandEnum.OFFERS_LIST_URL,
                        StringConditionOperatorEnum.EQUALS_ANY, new String[]{httpsUrl}},
                {"Создать правило(OFFERS_LIST_URL) со ссылкой, состоящей из русских букв",
                        WebpageConditionOperandEnum.OFFERS_LIST_URL,
                        StringConditionOperatorEnum.EQUALS_ANY, new String[]{russianUrl}},
                {"Создать правило(OFFERS_LIST_URL) со ссылкой, состоящей из украинских букв",
                        WebpageConditionOperandEnum.OFFERS_LIST_URL,
                        StringConditionOperatorEnum.EQUALS_ANY, new String[]{ukrainianUrl}},
                {"Создать правило(OFFERS_LIST_URL) со ссылкой, содержащей цифры",
                        WebpageConditionOperandEnum.OFFERS_LIST_URL,
                        StringConditionOperatorEnum.EQUALS_ANY, new String[]{numericUrl}},
                {"Создать правило(OFFERS_LIST_URL) со ссылкой, содержащей дефисы",
                        WebpageConditionOperandEnum.OFFERS_LIST_URL,
                        StringConditionOperatorEnum.EQUALS_ANY, new String[]{dashedUrl}},
                {"Создать правило(OFFERS_LIST_URL) со ссылкой, длиной "
                        + WebpageConditionMap.MAX_LENGTH_OF_OFFERS_LIST_URL_ARGUMENT,
                        WebpageConditionOperandEnum.OFFERS_LIST_URL, StringConditionOperatorEnum.EQUALS_ANY,
                        new String[]{maxLengthUrlForOffersList}},
                {"Создать правило(OFFERS_LIST_URL) с " + WebpageConditionMap.MAX_ARGUMENTS_AMOUNT + " ссылками",
                        WebpageConditionOperandEnum.OFFERS_LIST_URL, StringConditionOperatorEnum.EQUALS_ANY,
                        maxAmountOfArguments},
        });
    }


    @BeforeClass
    public static void initTest() {
        cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
    }

    @Before
    public void createGroup() {
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    public void addWithValidArguments() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.AddRequestMap()
                        .withWebpages(new WebpageAddItemMap()
                                .withAdGroupId(pid)
                                .withName("Name")
                                .withConditions(
                                        new WebpageConditionMap()
                                                .withOperator(operator)
                                                .withArguments(arguments)
                                                .withOperand(operand)
                                )
                                .withBid(30000000L)
                        ),
                ExpectedResult.success()
        );
    }

    private static String generateValidHrefWithoutProtocolOfLength(int length) {
        StringBuilder stringBuilder = new StringBuilder(randomAlphabetic(length));
        int domainLength = Math.min(
                (TextAdAddMap.MAX_DOMAIN_LENGTH - 1) / 2, (TextAdAddMap.MAX_TOP_DOMAIN_LENGTH - 1) / 2);
        for (int i = domainLength; i < length - domainLength; i += domainLength) {
            stringBuilder.setCharAt(i, '.');
        }
        return stringBuilder.toString();
    }
}
