package ru.yandex.autotests.directapi.dynamictextadtargets.add.strategy;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static com.sun.xml.ws.util.StringUtils.capitalize;

/**
 * Created by ginger on 09.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.ADD)
@Description("Попытка выставить Bid при автоматической стратегии на поиске")
@RunWith(Parameterized.class)
public class AddAutoStrategyBidTest {
    private static String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT_ADD;
    private static final Integer goalId = MetrikaGoals.getRandom();
    private Long pid;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public DynamicTextCampaignSearchStrategyTypeEnum searchStrategyName;

    @Parameterized.Parameter(1)
    public DynamicTextCampaignSearchStrategyMap searchStrategy;

    @Parameterized.Parameters(name = "searchStrategyName = {0}")
    public static Collection data() {
        return Arrays.asList(new Object[][]{
                {DynamicTextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS,
                        new DynamicTextCampaignSearchStrategyMap().defaultWbMaximumClicks(Currency.RUB)},
                {DynamicTextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CONVERSION_RATE,
                        new DynamicTextCampaignSearchStrategyMap().defaultWbMaximumConversionRate(Currency.RUB, 0L)},
                {DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_CPC,
                        new DynamicTextCampaignSearchStrategyMap().defaultAverageCpc(Currency.RUB)},
                {DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_CPA,
                        new DynamicTextCampaignSearchStrategyMap().defaultAverageCpa(Currency.RUB, 0L)},
                {DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_ROI,
                        new DynamicTextCampaignSearchStrategyMap().defaultAverageRoi(0L)},
        });
    }

    @Before
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        Long cid = api.as(LOGIN).userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().addCampMetrikaGoals(cid, goalId.longValue(), 100L, 100L);
        api.userSteps.campaignSteps().campaignsUpdate(new UpdateRequestMap()
                .withCampaigns(new CampaignUpdateItemMap()
                        .withId(cid)
                        .withDynamicTextCampaign(
                                new DynamicTextCampaignUpdateItemMap()
                                        .withBiddingStrategy(new DynamicTextCampaignStrategyMap()
                                                .withSearch(searchStrategy)
                                                .withNetwork(
                                                        new DynamicTextCampaignNetworkStrategyMap().defaultServingOff())))));
        //Фейково делаем кампанию динамической
        api.userSteps.campaignFakeSteps().setType(cid, CampaignsType.DYNAMIC);
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
    }

    @Test
    public void tryAddWithBid() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withWebpages(new WebpageAddItemMap()
                        .withAdGroupId(pid)
                        .withName("Name")
                        .withBid(30000000l)
                ),
                ExpectedResult.warnings(
                        new Notification(10160,
                                Api5ErrorDetails.BID_WILL_NOT_APPLIED_BECAUSE_OF_AUTO_STRATEGY,
                                capitalize(WebpageAddItemMap.BID)))
        );
    }
}
