package ru.yandex.autotests.directapi.dynamictextadtargets.add.strategy;

import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.money.MoneyFormat;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.bids.BidsGetItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang.StringUtils.capitalize;

/**
 * Created by ginger on 24.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.BUG)
@Description("Проверка работы метода со значениями Bid, которые больше максимально и меньше минимального")
@RunWith(Parameterized.class)
public class AddBoundaryValueOfBidNegativeTest {
    private Long pid;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String login;

    @Parameterized.Parameter(1)
    public Long valueOfBid;

    @Parameterized.Parameter(2)
    public Notification notification;

    @Parameterized.Parameters(name = "currencyLogin = {0}, valueOfMaxBid = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {DynamicTextAdTargetsLogins.BIDS_CLIENT_UAH,
                        MoneyCurrency.get(Currency.UAH).getMinPrice().getPrevious().bidLong().longValue(),
                        //значения меньше минимальной ставки
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_LESS,
                                capitalize(WebpageAddItemMap.BID),
                                (MoneyCurrency.get(Currency.UAH).getNameCasusDativus("en")),      //ToDo приведение к единому виду констант языковых!
                                MoneyCurrency.get(Currency.UAH).getLongMinPrice().stringValue(MoneyFormat.INTEGER))},
                {DynamicTextAdTargetsLogins.BIDS_CLIENT_KZT,
                        MoneyCurrency.get(Currency.KZT).getMinPrice().getPrevious().bidLong().longValue(),
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_LESS,
                                capitalize(WebpageAddItemMap.BID),
                                (MoneyCurrency.get(Currency.KZT).getNameCasusDativus("en")),
                                MoneyCurrency.get(Currency.KZT).getLongMinPrice().stringValue(MoneyFormat.INTEGER))},
                {DynamicTextAdTargetsLogins.BIDS_CLIENT_EUR,
                        MoneyCurrency.get(Currency.EUR).getMinPrice().getPrevious().bidLong().longValue(),
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_LESS,
                                capitalize(WebpageAddItemMap.BID),
                                (MoneyCurrency.get(Currency.EUR).getAbbreviation("en")),
                                MoneyCurrency.get(Currency.EUR).getLongMinPrice().stringValue(MoneyFormat.INTEGER))},
                {DynamicTextAdTargetsLogins.BIDS_CLIENT_CHF,
                        MoneyCurrency.get(Currency.CHF).getMinPrice().getPrevious().bidLong().longValue(),
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_LESS,
                                capitalize(WebpageAddItemMap.BID),
                                (MoneyCurrency.get(Currency.CHF).getNameCasusDativus("en")),
                                MoneyCurrency.get(Currency.CHF).getLongMinPrice().stringValue(MoneyFormat.INTEGER))},
                {DynamicTextAdTargetsLogins.BIDS_CLIENT_TRY,
                        MoneyCurrency.get(Currency.TRY).getMinPrice().getPrevious().bidLong().longValue(),
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_LESS,
                                capitalize(WebpageAddItemMap.BID),
                                (MoneyCurrency.get(Currency.TRY).getNamePluralI("en")),
                                MoneyCurrency.get(Currency.TRY).getLongMinPrice().stringValue(MoneyFormat.INTEGER))},
                {DynamicTextAdTargetsLogins.BIDS_CLIENT_RUB,
                        MoneyCurrency.get(Currency.RUB).getMinPrice().getPrevious().bidLong().longValue(),
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_LESS,
                                capitalize(WebpageAddItemMap.BID),
                                (MoneyCurrency.get(Currency.RUB).getNamePluralI("en")),
                                MoneyCurrency.get(Currency.RUB).getLongMinPrice().stringValue(MoneyFormat.INTEGER))},
                {DynamicTextAdTargetsLogins.BIDS_CLIENT_USD,
                        MoneyCurrency.get(Currency.USD).getMinPrice().getPrevious().bidLong().longValue(),
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_LESS,
                                capitalize(WebpageAddItemMap.BID),
                                (MoneyCurrency.get(Currency.USD).getNameCasusDativus("en")),
                                MoneyCurrency.get(Currency.USD).getLongMinPrice().stringValue(MoneyFormat.INTEGER))},
                {DynamicTextAdTargetsLogins.CLIENT_BYN,
                        MoneyCurrency.get(Currency.BYN).getMinPrice().getPrevious().bidLong().longValue(),
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_LESS,
                                StringUtils.capitalize(BidsGetItemMap.BID),
                                (MoneyCurrency.get(Currency.BYN).getNamePluralI("en")),
                                MoneyCurrency.get(Currency.BYN).getLongMinPrice().stringValue(MoneyFormat.INTEGER))},
                {DynamicTextAdTargetsLogins.BIDS_CLIENT_UAH,
                        MoneyCurrency.get(Currency.UAH).getMaxPrice().getNext().bidLong().longValue(),
                        //значения больше максимальной ставки на шаг торгов
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_MORE,
                                capitalize(WebpageAddItemMap.BID),
                                (MoneyCurrency.get(Currency.UAH).getNameCasusDativus("en")),
                                MoneyCurrency.get(Currency.UAH).getLongMaxPrice().stringValue(MoneyFormat.INTEGER))},
                {DynamicTextAdTargetsLogins.BIDS_CLIENT_KZT,
                        MoneyCurrency.get(Currency.KZT).getMaxPrice().getNext().bidLong().longValue(),
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_MORE,
                                capitalize(WebpageAddItemMap.BID),
                                (MoneyCurrency.get(Currency.KZT).getNameCasusDativus("en")),
                                MoneyCurrency.get(Currency.KZT).getLongMaxPrice().stringValue(MoneyFormat.INTEGER))},
                {DynamicTextAdTargetsLogins.BIDS_CLIENT_EUR,
                        MoneyCurrency.get(Currency.EUR).getMaxPrice().getNext().bidLong().longValue(),
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_MORE,
                                capitalize(WebpageAddItemMap.BID),
                                (MoneyCurrency.get(Currency.EUR).getAbbreviation("en")),
                                MoneyCurrency.get(Currency.EUR).getLongMaxPrice().stringValue(MoneyFormat.INTEGER))},
                {DynamicTextAdTargetsLogins.BIDS_CLIENT_CHF,
                        MoneyCurrency.get(Currency.CHF).getMaxPrice().getNext().bidLong().longValue(),
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_MORE,
                                capitalize(WebpageAddItemMap.BID),
                                (MoneyCurrency.get(Currency.CHF).getNameCasusDativus("en")),
                                MoneyCurrency.get(Currency.CHF).getLongMaxPrice().stringValue(MoneyFormat.INTEGER))},
                {DynamicTextAdTargetsLogins.BIDS_CLIENT_TRY,
                        MoneyCurrency.get(Currency.TRY).getMaxPrice().getNext().bidLong().longValue(),
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_MORE,
                                capitalize(WebpageAddItemMap.BID),
                                (MoneyCurrency.get(Currency.TRY).getNamePluralI("en")),
                                MoneyCurrency.get(Currency.TRY).getLongMaxPrice().stringValue(MoneyFormat.INTEGER))},
                {DynamicTextAdTargetsLogins.BIDS_CLIENT_RUB,
                        MoneyCurrency.get(Currency.RUB).getMaxPrice().getNext().bidLong().longValue(),
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_MORE,
                                capitalize(WebpageAddItemMap.BID),
                                (MoneyCurrency.get(Currency.RUB).getNamePluralI("en")),
                                MoneyCurrency.get(Currency.RUB).getLongMaxPrice().stringValue(MoneyFormat.INTEGER))},
                {DynamicTextAdTargetsLogins.BIDS_CLIENT_USD,
                        MoneyCurrency.get(Currency.USD).getMaxPrice().getNext().bidLong().longValue(),
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_MORE,
                                capitalize(WebpageAddItemMap.BID),
                                (MoneyCurrency.get(Currency.USD).getNameCasusDativus("en")),
                                MoneyCurrency.get(Currency.USD).getLongMaxPrice().stringValue(MoneyFormat.INTEGER))},
                {DynamicTextAdTargetsLogins.CLIENT_BYN,
                        MoneyCurrency.get(Currency.BYN).getMaxPrice().getNext().bidLong().longValue(),
                        new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_MORE,
                                StringUtils.capitalize(BidsGetItemMap.BID),
                                (MoneyCurrency.get(Currency.BYN).getNamePluralI("en")),
                                MoneyCurrency.get(Currency.BYN).getLongMaxPrice().stringValue(MoneyFormat.INTEGER))}
        };
        return Arrays.asList(data);
    }

    @Before
    public void initTest() {
        api.as(login);
        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);
        api.as(login);
    }

    @Title("DIRECT-48788")
    @Test
    public void tryAddWithInvalidBid() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.AddRequestMap().withWebpages(new WebpageAddItemMap()
                        .withAdGroupId(pid)
                        .withName("Name")
                        .withBid(valueOfBid)
                ),
                ExpectedResult.errors(notification)
        );
    }
}
