package ru.yandex.autotests.directapi.dynamictextadtargets.add.strategy;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 24.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.ADD)
@Description("Проверка работы метода с граничными значениями Bid")
@RunWith(Parameterized.class)
public class AddBoundaryValueOfBidPositiveTest {
    private Long pid;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String login;

    @Parameterized.Parameter(1)
    public Long valueOfBid;

    @Parameterized.Parameters(name = "currencyLogin = {0}, valueOfMaxBid = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {DynamicTextAdTargetsLogins.BIDS_CLIENT_UAH, MoneyCurrency.get(Currency.UAH).getMinPrice().bidLong().longValue()},       //минимальные допустимые ставки
                {DynamicTextAdTargetsLogins.BIDS_CLIENT_KZT, MoneyCurrency.get(Currency.KZT).getMinPrice().bidLong().longValue()},
                {DynamicTextAdTargetsLogins.BIDS_CLIENT_EUR, MoneyCurrency.get(Currency.EUR).getMinPrice().bidLong().longValue()},
                {DynamicTextAdTargetsLogins.BIDS_CLIENT_CHF, MoneyCurrency.get(Currency.CHF).getMinPrice().bidLong().longValue()},
                {DynamicTextAdTargetsLogins.BIDS_CLIENT_TRY, MoneyCurrency.get(Currency.TRY).getMinPrice().bidLong().longValue()},
                {DynamicTextAdTargetsLogins.BIDS_CLIENT_RUB, MoneyCurrency.get(Currency.RUB).getMinPrice().bidLong().longValue()},
                {DynamicTextAdTargetsLogins.BIDS_CLIENT_USD, MoneyCurrency.get(Currency.USD).getMinPrice().bidLong().longValue()},
                {DynamicTextAdTargetsLogins.CLIENT_BYN, MoneyCurrency.get(Currency.BYN).getMinPrice().bidLong().longValue()},
                {DynamicTextAdTargetsLogins.BIDS_CLIENT_UAH, MoneyCurrency.get(Currency.UAH).getMaxPrice().bidLong().longValue()},  //максимальные допустимые ставки
                {DynamicTextAdTargetsLogins.BIDS_CLIENT_KZT, MoneyCurrency.get(Currency.KZT).getMaxPrice().bidLong().longValue()},
                {DynamicTextAdTargetsLogins.BIDS_CLIENT_EUR, MoneyCurrency.get(Currency.EUR).getMaxPrice().bidLong().longValue()},
                {DynamicTextAdTargetsLogins.BIDS_CLIENT_CHF, MoneyCurrency.get(Currency.CHF).getMaxPrice().bidLong().longValue()},
                {DynamicTextAdTargetsLogins.BIDS_CLIENT_TRY, MoneyCurrency.get(Currency.TRY).getMaxPrice().bidLong().longValue()},
                {DynamicTextAdTargetsLogins.BIDS_CLIENT_RUB, MoneyCurrency.get(Currency.RUB).getMaxPrice().bidLong().longValue()},
                {DynamicTextAdTargetsLogins.BIDS_CLIENT_USD, MoneyCurrency.get(Currency.USD).getMaxPrice().bidLong().longValue()},
                {DynamicTextAdTargetsLogins.CLIENT_BYN, MoneyCurrency.get(Currency.BYN).getMaxPrice().bidLong().longValue()}
        };
        return Arrays.asList(data);
    }

    @Before
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);
        Long cid = api.as(login).userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
    }

    @Test
    public void addWithBid() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.AddRequestMap().withWebpages(
                        new WebpageAddItemMap()
                                .withAdGroupId(pid)
                                .withName("Name")
                                .withBid(valueOfBid)
                ),
                ExpectedResult.success()
        );
    }
}
