package ru.yandex.autotests.directapi.dynamictextadtargets.add.strategy;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.general.PriorityEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static com.sun.xml.ws.util.StringUtils.capitalize;

/**
 * Created by ginger on 24.11.15.
 * <p>
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.ADD)
@Description("Попытка выставить Priority при ручной стратегии на поиске")
@RunWith(Parameterized.class)
public class AddManualStrategyPriorityTest {
    private static String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT_ADD;
    private Long pid;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public TextCampaignSearchStrategyTypeEnum searchStrategyName;

    @Parameterized.Parameters(name = "searchStrategyName = {0}")
    public static Collection data() {
        return Arrays.asList(new Object[][]{
                {TextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION},
                {TextCampaignSearchStrategyTypeEnum.IMPRESSIONS_BELOW_SEARCH}
        });
    }

    @Before
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long cid = api.as(LOGIN).userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
    }

    @Test
    public void tryAddWithStrategyPriority() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withWebpages(new WebpageAddItemMap()
                        .withAdGroupId(pid)
                        .withName("Name")
                        .withStrategyPriority(PriorityEnum.HIGH)
                ),
                ExpectedResult.warnings(
                        new Notification(10161,
                                Api5ErrorDetails.FIELD_WILL_NOT_CHANGE_BECAUSE_OF_MANUAL_STRATEGY,
                                capitalize(WebpageAddItemMap.STRATEGY_PRIORITY)))
        );
    }
}
