package ru.yandex.autotests.directapi.dynamictextadtargets.add.strategy;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.general.PriorityEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsDynamicRecord;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;

/**
 * Created by ginger on 30.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.ADD)
@RunWith(Parameterized.class)
public class AddStrategyPriorityTest {
    private static String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT_ADD;
    private static int shard;
    private static Long cid;
    private static Long pid;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public PriorityEnum strategyPriority;

    @Parameterized.Parameter(1)
    public Integer expectedDBValue;

    @Parameterized.Parameters(name = "searchStrategyName = {0}")
    public static Collection data() {
        return Arrays.asList(new Object[][]{
                {PriorityEnum.HIGH, 5},
                {PriorityEnum.LOW, 1},
                {PriorityEnum.NORMAL, 3}
        });
    }

    @BeforeClass
    public static void initTest() {
        cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign(LOGIN);
        api.userSteps.campaignSteps().campaignsUpdate(new UpdateRequestMap()
                .withCampaigns(new CampaignUpdateItemMap()
                        .withId(cid)
                        .withDynamicTextCampaign(
                                new DynamicTextCampaignUpdateItemMap()
                                        .withBiddingStrategy(new DynamicTextCampaignStrategyMap()
                                                .withSearch(
                                                        new DynamicTextCampaignSearchStrategyMap().defaultWbMaximumClicks(Currency.RUB))
                                                .withNetwork(
                                                        new DynamicTextCampaignNetworkStrategyMap().defaultServingOff())))));
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    public void createGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
    }

    @Test
    public void addWithStrategyPriority() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.AddRequestMap().withWebpages(
                        new WebpageAddItemMap()
                                .withAdGroupId(pid)
                                .withName("Name")
                                .withStrategyPriority(strategyPriority)
                ),
                ExpectedResult.success()
        );
        BidsDynamicRecord bidsDynamic = api.userSteps.getDirectJooqDbSteps().useShard(shard).bidsDynamicSteps()
                .getBidsDynamicByPid(pid).get(0);
        assertThat("выставилось верное значение StrategyPriority", bidsDynamic.getAutobudgetpriority(), equalTo(expectedDBValue));
    }
}
