package ru.yandex.autotests.directapi.dynamictextadtargets.add.strategy;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.general.PriorityEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsDynamicRecord;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 24.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.ADD)
@Description("Проверка записи в БД дефолтных значений Bid и ContextBid ")
@RunWith(Parameterized.class)
public class AddWithoutBidAndContextBidTest {
    private static String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT_ADD;
    private static final Integer goalId = MetrikaGoals.getRandom();
    private static final Money minValue = MoneyCurrency.get(Currency.RUB).getMinPrice();
    private Long pid;
    private List<BidsDynamicRecord> webpagesOfPid;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public DynamicTextCampaignSearchStrategyTypeEnum searchStrategyName;

    @Parameterized.Parameter(1)
    public DynamicTextCampaignSearchStrategyMap searchStrategy;

    @Parameterized.Parameters(name = "searchStrategyName = {0}")
    public static Collection data() {
        return Arrays.asList(new Object[][]{
                {DynamicTextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS,
                        new DynamicTextCampaignSearchStrategyMap().defaultWbMaximumClicks(Currency.RUB)},
                {DynamicTextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CONVERSION_RATE,
                        new DynamicTextCampaignSearchStrategyMap().defaultWbMaximumConversionRate(Currency.RUB, 0L)},
                {DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_CPC,
                        new DynamicTextCampaignSearchStrategyMap().defaultAverageCpc(Currency.RUB)},
                {DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_CPA,
                        new DynamicTextCampaignSearchStrategyMap().defaultAverageCpa(Currency.RUB, 0L)},
                {DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_ROI,
                        new DynamicTextCampaignSearchStrategyMap().defaultAverageRoi(0L)},
        });
    }

    @Before
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long cid = api.as(LOGIN).userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().addCampMetrikaGoals(cid, goalId.longValue(), 100L, 100L);
        api.userSteps.campaignSteps().campaignsUpdate(new UpdateRequestMap()
                .withCampaigns(new CampaignUpdateItemMap()
                        .withId(cid)
                        .withDynamicTextCampaign(
                                new DynamicTextCampaignUpdateItemMap()
                                        .withBiddingStrategy(new DynamicTextCampaignStrategyMap()
                                                .withSearch(searchStrategy)
                                                .withNetwork(
                                                        new DynamicTextCampaignNetworkStrategyMap().defaultServingOff())))));
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withWebpages(
                        new WebpageAddItemMap()
                                .withAdGroupId(pid)
                                .withName("Name")
                                .withStrategyPriority(PriorityEnum.HIGH)
                ),
                ExpectedResult.success()
        );

        webpagesOfPid = api.userSteps.getDirectJooqDbSteps().useShard(shard).bidsDynamicSteps()
                .getBidsDynamicByPid(pid);
        assumeThat("создалась динамическая группа с 1 Webpage", webpagesOfPid, iterableWithSize(1));
    }

    @Test
    public void expectMinValueOfBid() {
        assertThat("выставилась минимальная ставка Bid", webpagesOfPid.get(0).getPrice().floatValue(),
                equalTo(minValue.floatValue()));
    }

    @Test
    public void expectMinValueOfContextBid() {
        assertThat("выставилась минимальная ставка ContextBid", webpagesOfPid.get(0).getPriceContext().floatValue(),
                equalTo(minValue.floatValue()));
    }
}
