package ru.yandex.autotests.directapi.dynamictextadtargets.delete;

import com.yandex.direct.api.v5.dynamictextadtargets.AddResponse;
import com.yandex.direct.api.v5.dynamictextadtargets.StringConditionOperatorEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageConditionOperandEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageConditionMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 26.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.DELETE)
public class DeleteDBTest {
    private static final String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT_DELETE;
    private static Long cid;
    private Long firstWebpage;
    private static int shard;
    private static Long pid;
    private static AddResponse response;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign(LOGIN);
    }

    @Before
    public void createWebpages(){
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        response =  api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(new WebpageAddItemMap()
                                .withAdGroupId(pid)
                                .withName("Name")
                                .withConditions(new WebpageConditionMap()
                                        .withOperand(WebpageConditionOperandEnum.PAGE_TITLE)
                                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                                        .withArguments("ginger")
                                )
                                .withBid(30000000l)
                        ),
                ExpectedResult.success()

        );
        assumeThat("создалась динамическая группа с 1 Webpages", response.getAddResults(), hasSize(1));
        firstWebpage = response.getAddResults().get(0).getId();
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnDelete(
                new DeleteRequestMap()
                        .withSelectionCriteria(
                                new IdsCriteriaMap()
                                        .withIds(firstWebpage)
                        ),
                ExpectedResult.success());
    }


    @Test
    @Description("Удалить одно условие нацеливания")
    public void deleteOneWebpage() {
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .dynamicConditionsSteps()
                .getDynamicConditionByAdgroupId(pid);

        api.userSteps.getDirectJooqDbSteps().bidsSteps()
                .getBidsDynamicByPid(pid);

        response =  api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(new WebpageAddItemMap()
                                .withAdGroupId(pid)
                                .withName("Name")
                                .withConditions(new WebpageConditionMap()
                                        .withOperand(WebpageConditionOperandEnum.PAGE_TITLE)
                                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                                        .withArguments("ginger")
                                )
                                .withBid(30000000l)
                        ),
                ExpectedResult.success()

        );
        assertThat("", response.getAddResults().get(0).getId(), equalTo(firstWebpage));
    }


}
