package ru.yandex.autotests.directapi.dynamictextadtargets.delete;

import org.apache.commons.lang3.ArrayUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.textresource.TextResourceFormatter;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlApi5Error;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 06.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.DELETE)
@Description("Попытка удаления условий нацеливаний, число которых больше максимального")
public class DeleteIdsLengthRestrictionNegativeTest {

    private static final String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT_DELETE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Удалить условия нацеливания, число которых больше " + IdsCriteriaMap.IDS_MAX_LENGTH + " за один запрос")
    public void deleteGreaterThanMaxWebpagesWithOneRequest() {
        Long[] webpagesIDs = ArrayUtils.toObject(new long[IdsCriteriaMap.IDS_MAX_LENGTH + 1]);

        Api5Error javaError =
                new Api5Error(4001, Api5ErrorDetails.ALLOW_DELETE_NO_MORE_WEBPAGES, IdsCriteriaMap.IDS_MAX_LENGTH);

        javaError.getFaultInfo().setErrorDetail(
                TextResourceFormatter
                        .resource(Api5ErrorDetails.ALLOW_DELETE_NO_MORE_WEBPAGES)
                        .args(IdsCriteriaMap.IDS_MAX_LENGTH)
                        .locale("ru")
                        .toString()
        ); // исправить заданный текст на русском на честную локализацию, когда приедут переводы. DIRECT-92767

        JavaOrPerlApi5Error javaOrPerlApi5Error = JavaOrPerlApi5Error
                .java(javaError)
                .perl(new Api5Error(4001, Api5ErrorDetails.ALLOW_DELETE_NO_MORE_WEBPAGES,
                        IdsCriteriaMap.IDS_MAX_LENGTH));

        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsDelete(
                new DeleteRequestMap()
                        .withSelectionCriteria(
                                new IdsCriteriaMap()
                                        .withIds(webpagesIDs)),
                javaOrPerlApi5Error);
    }
}
