package ru.yandex.autotests.directapi.dynamictextadtargets.delete;

import org.apache.commons.lang3.ArrayUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageGetItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;

import static com.sun.xml.ws.util.StringUtils.capitalize;

/**
 * Created by ginger on 06.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.NOT_REGRESSION_YET)
@Description("Удаление максимального числа условий нацеливаний за один запрос")
public class DeleteIdsLengthRestrictionTest {

    private static final String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT_DELETE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);
    private int shard;

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Удалить " + IdsCriteriaMap.IDS_MAX_LENGTH + " условий нацеливаний за один запрос")
    public void deleteMaxWebpagesWithOneRequest() {
        Long[] webpageIDs = ArrayUtils.toObject(new long[IdsCriteriaMap.IDS_MAX_LENGTH]);
        for (int i = 0; i < webpageIDs.length; i++) {
            webpageIDs[i] = (long) -i;
        }

        ExpectedResult[] expectedResults = new ExpectedResult[IdsCriteriaMap.IDS_MAX_LENGTH];
        Arrays.fill(expectedResults, ExpectedResult.errors(
                new Notification(5005, Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER, capitalize(WebpageGetItemMap.ID))));
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnDelete(
                    new DeleteRequestMap()
                        .withSelectionCriteria(
                                new IdsCriteriaMap()
                                        .withIds(webpageIDs)),
                expectedResults
        );
    }
}
