package ru.yandex.autotests.directapi.dynamictextadtargets.delete;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.Phrases;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher;
import ru.yandex.autotests.irt.testutils.beandiffer2.beanfield.BeanFieldPath;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by ginger on 06.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */

@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.DELETE)
@Description("Удаление последнего активного условия нацеливания в группе")
public class DeleteLastWebpageInAdGroupTest {

    private static final String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT_SUSPEND;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private int shard;
    private BeanDifferMatcher expectedAdMatcher;
    private BeanDifferMatcher expectedAdGroupMatcher;
    private DirectJooqDbSteps directJooqDbSteps;
    private Long adGroupId;
    private Long adId;
    private Long webpageTargetId;

    @Before
    @Step("Подготовка данных для теста")
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        shard = api.userSteps.getDirectJooqDbSteps().shardingSteps().getShardByLogin(LOGIN);

        directJooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);

        Long campaignId = api.as(LOGIN).userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        adId = api.userSteps.adsSteps().addDefaultDynamicTextAd(adGroupId);
        webpageTargetId = api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(adGroupId);

        api.userSteps.bannersFakeSteps().makeBannersActiveAndFullyModerated(adId);
        directJooqDbSteps.adGroupsSteps().makePhraseModeratedAndBsSynced(adGroupId);
        api.userSteps.campaignFakeSteps().makeCampaignActive(campaignId);

        BannersRecord expectedAd = directJooqDbSteps.bannersSteps().getBanner(adId);
        expectedAd.setStatusbssynced(BannersStatusbssynced.No);
        expectedAdMatcher = beanDiffer(expectedAd.intoMap());

        PhrasesRecord expectedAdGroup = directJooqDbSteps.adGroupsSteps().getPhrases(adGroupId);
        expectedAdGroup.setStatusbssynced(PhrasesStatusbssynced.No);
        expectedAdGroupMatcher = beanDiffer(expectedAdGroup.intoMap()).useCompareStrategy(
                DefaultCompareStrategies.allFieldsExcept(
                        BeanFieldPath.newPath(Phrases.PHRASES.LASTCHANGE.getName())));
    }

    @Test
    @Description("Удаление последнего активного условия нацеливания в группе")
    public void deleteLastActiveWebpageTargetInAdGroupTest() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnDelete(new IdsCriteriaMap().withIds(webpageTargetId),
                ExpectedResult.success());

        BannersRecord ad = directJooqDbSteps.bannersSteps().getBanner(adId);
        assertThat("в БД баннер находится в ожидаемом состоянии", ad.intoMap(), expectedAdMatcher);

        PhrasesRecord adGroup = directJooqDbSteps.adGroupsSteps().getPhrases(adGroupId);
        assertThat("в БД группа находится в ожидаемом состоянии", adGroup.intoMap(), expectedAdGroupMatcher);
    }
}
