package ru.yandex.autotests.directapi.dynamictextadtargets.get;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.dynamictextadtargets.GetResponse;
import com.yandex.direct.api.v5.dynamictextadtargets.StringConditionOperatorEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageConditionOperandEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageFieldEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageConditionMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageGetItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpagesSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by ginger on 16.10.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.GET)
@Description("Проверка фильтрации по CampaignIds")
public class GetCampaignIdsTest {
    private static String client = DynamicTextAdTargetsLogins.SINGLE_CLIENT_GET;
    private static Long anotherClientCampaignId = 263l;
    private static int shard;
    private static Long cid1;
    private static Long pid1;
    private static Long cid2;
    private static Long pid2;
    private static Long deletedCid;
    private static List<Long> webpageIdsOfPid1;
    private static List<Long> webpageIdsOfPid2;
    private static Long deletedPid;
    private GetResponse getResponse;
    private static Long cid3;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        shard = api.userSteps.clientFakeSteps().getUserShard(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);

        cid1 = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid1 = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid1);
        webpageIdsOfPid1 = api.userSteps.dynamicTextAdTargetsSteps().addWebpages(
                new WebpageAddItemMap()
                        .withAdGroupId(pid1)
                        .withConditions(new WebpageConditionMap()
                                .withOperand(WebpageConditionOperandEnum.PAGE_CONTENT)
                                .withOperator(StringConditionOperatorEnum.NOT_CONTAINS_ALL)
                                .withArguments("ginger")
                        )
                        .withName("Name1"),
                new WebpageAddItemMap()
                        .withAdGroupId(pid1)
                        .withConditions(new WebpageConditionMap()
                                .withOperand(WebpageConditionOperandEnum.PAGE_TITLE)
                                .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                                .withArguments("картоха")
                        )
                        .withName("Name2")
        );

        cid2 = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid2 = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid2);
        webpageIdsOfPid2 = api.userSteps.dynamicTextAdTargetsSteps().addWebpages(
                new WebpageAddItemMap()
                        .withAdGroupId(pid2)
                        .withConditions(new WebpageConditionMap()
                                .withOperand(WebpageConditionOperandEnum.PAGE_CONTENT)
                                .withOperator(StringConditionOperatorEnum.NOT_CONTAINS_ALL)
                                .withArguments("ginger")
                        )
                        .withName("Name1")
        );


        deletedCid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        deletedPid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(deletedCid);
        api.userSteps.campaignSteps().campaignsDelete(deletedCid);

        cid3 = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        Long dynamicTextFeedAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid3);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(dynamicTextFeedAdGroupId);
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        Long feedId = jooqDbSteps.feedsSteps().createDefaultFeed(User.get(client).getClientID());
        jooqDbSteps.adGroupsSteps().convertAdgroupDynamicToDynamicByFeed(dynamicTextFeedAdGroupId, feedId);

    }

    @Test
    public void getByOneCampaignId() {
        getResponse = api.as(Logins.SUPER_LOGIN).userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withCampaignIds(cid1)
                )
                        .withFieldNames(WebpageFieldEnum.CAMPAIGN_ID),
                client
        );
        assumeThat("вернулось 2 Webpages", getResponse.getWebpages(), iterableWithSize(2));
        assertThat("вернулся ожидаемый Webpages", getResponse.getWebpages(),
                beanDiffer(Arrays.asList(
                        (WebpageGetItem) new WebpageGetItemMap().withCampaignId(cid1).getBean(),
                        (WebpageGetItem) new WebpageGetItemMap().withCampaignId(cid1).getBean()
                )));
    }

    @Test
    public void getBySomeCampaignId() {
        getResponse = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withCampaignIds(cid1, cid2)
                )
                        .withFieldNames(WebpageFieldEnum.CAMPAIGN_ID, WebpageFieldEnum.ID)
        );
        assumeThat("вернулось 3 Webpages", getResponse.getWebpages(), iterableWithSize(3));
        assertThat("вернулся ожидаемый Webpages", getResponse.getWebpages(),
                beanDiffer(Arrays.asList(
                        (WebpageGetItem) new WebpageGetItemMap().withCampaignId(cid1).withId(webpageIdsOfPid1.get(0)).getBean(),
                        (WebpageGetItem) new WebpageGetItemMap().withCampaignId(cid1).withId(webpageIdsOfPid1.get(1)).getBean(),
                        (WebpageGetItem) new WebpageGetItemMap().withCampaignId(cid2).withId(webpageIdsOfPid2.get(0)).getBean()
                )));
    }

    @Test
    public void getByDuplicatedCampaignId() {
        getResponse = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withCampaignIds(cid1, cid1)
                )
                        .withFieldNames(WebpageFieldEnum.CAMPAIGN_ID, WebpageFieldEnum.ID)
        );
        assumeThat("вернулся 2 Webpages", getResponse.getWebpages(), iterableWithSize(2));
        assertThat("вернулся ожидаемый Id", getResponse.getWebpages(),
                beanDiffer(Arrays.asList(
                        (WebpageGetItem) new WebpageGetItemMap().withCampaignId(cid1).withId(webpageIdsOfPid1.get(0)).getBean(),
                        (WebpageGetItem) new WebpageGetItemMap().withCampaignId(cid1).withId(webpageIdsOfPid1.get(1)).getBean())
                ));
    }

    @Test
    public void getByNonExistentCampaignId() {
        getResponse = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withCampaignIds(pid1 + 1000)
                )
                        .withFieldNames(WebpageFieldEnum.CAMPAIGN_ID)
        );
        assertThat("вернулась 0 Webpages", getResponse.getWebpages(), hasSize(0));
    }

    @Test
    public void getByZeroId() {
        getResponse = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withCampaignIds(0l)
                )
                        .withFieldNames(WebpageFieldEnum.CAMPAIGN_ID)
        );
        assertThat("вернулась 0 Webpages", getResponse.getWebpages(), hasSize(0));
    }

    @Test
    public void getByNegativeId() {
        getResponse = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withCampaignIds(-pid1)
                )
                        .withFieldNames(WebpageFieldEnum.CAMPAIGN_ID)
        );
        assertThat("вернулась 0 Webpages", getResponse.getWebpages(), hasSize(0));
    }

    @Test
    public void getByDeletedId() {
        getResponse = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withCampaignIds(deletedPid)
                )
                        .withFieldNames(WebpageFieldEnum.CAMPAIGN_ID)
        );
        assertThat("вернулась 0 Webpages", getResponse.getWebpages(), hasSize(0));
    }

    @Test
    public void getAnotherClientId() {
        getResponse = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withCampaignIds(anotherClientCampaignId)
                )
                        .withFieldNames(WebpageFieldEnum.CAMPAIGN_ID)
        );
        assertThat("вернулась 0 Webpages", getResponse.getWebpages(), hasSize(0));
    }

    @Test
    public void getByCampaignIdWithDynamicTextFeedAdGroup() {
        getResponse = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withCampaignIds(cid3)
                )
                        .withFieldNames(WebpageFieldEnum.CAMPAIGN_ID)
        );
        assertThat("вернулась 0 Webpages", getResponse.getWebpages(), hasSize(0));
    }
}
