package ru.yandex.autotests.directapi.dynamictextadtargets.get;

import com.yandex.direct.api.v5.dynamictextadtargets.GetResponse;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageFieldEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageGetItem;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageTypeEnum;
import com.yandex.direct.api.v5.general.StateEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.StatusClarification;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageConditionMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageGetItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpagesSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by ginger on 21.10.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.GET)
@Description("Проверка фильтрации по FieldNames")
public class GetFieldNamesTest {
    private static String client = DynamicTextAdTargetsLogins.SINGLE_CLIENT_GET;
    private static Long cid;
    private static Long pid;
    private static Long id;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);
    private GetResponse getResponse;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);

        cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        id = api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
    }


    @Test
    public void getByAllFieldNames() {
        getResponse = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withIds(id)
                )
                        .withFieldNames(
                                WebpageFieldEnum.AD_GROUP_ID,
                                WebpageFieldEnum.BID,
                                WebpageFieldEnum.CAMPAIGN_ID,
                                WebpageFieldEnum.CONDITION_TYPE,
                                WebpageFieldEnum.CONDITIONS,
                                WebpageFieldEnum.CONTEXT_BID,
                                WebpageFieldEnum.ID,
                                WebpageFieldEnum.NAME,
                                WebpageFieldEnum.STATE,
                                WebpageFieldEnum.STATUS_CLARIFICATION)
                // WebpageFieldEnum.STRATEGY_PRIORITY)
        );
        assumeThat("вернулся 1 Webpages", getResponse.getWebpages(), iterableWithSize(1));
        assertThat("вернулся ожидаемый Id", getResponse.getWebpages().get(0),
                beanDiffer(
                        (WebpageGetItem) new WebpageGetItemMap()
                                .withId(id)
                                .withAdGroupId(pid)
                                .withBid(30000000l)
                                .withCampaignId(cid)
                                .withConditions(
                                        new WebpageConditionMap().defaultWebpage()
                                )
                                .withConditionType(WebpageTypeEnum.PAGES_SUBSET)
                                .withContextBid(MoneyCurrency.get(Currency.RUB).getMinPrice().bidLong().longValue())
                                .withName("Name")
                                .withState(StateEnum.ON)
                                .withStatusClarification(StatusClarification.WEBPAGE_RESUMED.getStatusClarification())
                                // .withStrategyPriority(PriorityEnum.HIGH)
                                .getBean()
                ));
    }

    @Test
    public void getByAdGroupId() {
        getResponse = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withIds(id)
                )
                        .withFieldNames(
                                WebpageFieldEnum.AD_GROUP_ID)
        );
        assumeThat("вернулся 1 Webpages", getResponse.getWebpages(), iterableWithSize(1));
        assertThat("вернулся ожидаемый Id", getResponse.getWebpages().get(0),
                beanDiffer(
                        (WebpageGetItem) new WebpageGetItemMap()
                                .withAdGroupId(pid)
                                .getBean()
                ));
    }

    @Test
    public void getByBid() {
        getResponse = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withIds(id)
                )
                        .withFieldNames(
                                WebpageFieldEnum.BID)
        );
        assumeThat("вернулся 1 Webpages", getResponse.getWebpages(), iterableWithSize(1));
        assertThat("вернулся ожидаемый Id", getResponse.getWebpages().get(0),
                beanDiffer(
                        (WebpageGetItem) new WebpageGetItemMap()
                                .withBid(30000000l)
                                .getBean()
                ));
    }

    @Test
    public void getByCampaignId() {
        getResponse = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withIds(id)
                )
                        .withFieldNames(
                                WebpageFieldEnum.CAMPAIGN_ID)
        );
        assumeThat("вернулся 1 Webpages", getResponse.getWebpages(), iterableWithSize(1));
        assertThat("вернулся ожидаемый Id", getResponse.getWebpages().get(0),
                beanDiffer(
                        (WebpageGetItem) new WebpageGetItemMap()
                                .withCampaignId(cid)
                                .getBean()
                ));
    }

    @Test
    public void getByConditions() {
        getResponse = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withIds(id)
                )
                        .withFieldNames(
                                WebpageFieldEnum.CONDITIONS)
        );
        assumeThat("вернулся 1 Webpages", getResponse.getWebpages(), iterableWithSize(1));
        assertThat("вернулся ожидаемый Id", getResponse.getWebpages().get(0),
                beanDiffer(
                        (WebpageGetItem) new WebpageGetItemMap()
                                .withConditions(
                                        new WebpageConditionMap().defaultWebpage()
                                )
                                .getBean()
                ));
    }

    @Test
    public void getByConditionType() {
        getResponse = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withIds(id)
                )
                        .withFieldNames(
                                WebpageFieldEnum.CONDITION_TYPE)
        );
        assumeThat("вернулся 1 Webpages", getResponse.getWebpages(), iterableWithSize(1));
        assertThat("вернулся ожидаемый Id", getResponse.getWebpages().get(0),
                beanDiffer(
                        (WebpageGetItem) new WebpageGetItemMap()
                                .withConditionType(WebpageTypeEnum.PAGES_SUBSET)
                                .getBean()
                ));
    }

    @Test
    public void getByContextBid() {
        getResponse = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withIds(id)
                )
                        .withFieldNames(
                                WebpageFieldEnum.CONTEXT_BID)
        );
        assumeThat("вернулся 1 Webpages", getResponse.getWebpages(), iterableWithSize(1));
        assertThat("вернулся ожидаемый Id", getResponse.getWebpages().get(0),
                beanDiffer(
                        (WebpageGetItem) new WebpageGetItemMap()
                                .withContextBid(MoneyCurrency.get(Currency.RUB).getMinPrice().bidLong().longValue())
                                .getBean()
                ));
    }

    @Test
    public void getById() {
        getResponse = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withIds(id)
                )
                        .withFieldNames(
                                WebpageFieldEnum.ID)
        );
        assumeThat("вернулся 1 Webpages", getResponse.getWebpages(), iterableWithSize(1));
        assertThat("вернулся ожидаемый Id", getResponse.getWebpages().get(0),
                beanDiffer(
                        (WebpageGetItem) new WebpageGetItemMap()
                                .withId(id)
                                .getBean()
                ));
    }

    @Test
    public void getByName() {
        getResponse = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withIds(id)
                )
                        .withFieldNames(
                                WebpageFieldEnum.NAME)
        );
        assumeThat("вернулся 1 Webpages", getResponse.getWebpages(), iterableWithSize(1));
        assertThat("вернулся ожидаемый Id", getResponse.getWebpages().get(0),
                beanDiffer(
                        (WebpageGetItem) new WebpageGetItemMap()
                                .withName("Name")
                                .getBean()
                ));
    }

    @Test
    public void getByState() {
        getResponse = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withIds(id)
                )
                        .withFieldNames(
                                WebpageFieldEnum.STATE)
        );
        assumeThat("вернулся 1 Webpages", getResponse.getWebpages(), iterableWithSize(1));
        assertThat("вернулся ожидаемый Id", getResponse.getWebpages().get(0),
                beanDiffer(
                        (WebpageGetItem) new WebpageGetItemMap()
                                .withState(StateEnum.ON)
                                .getBean()
                ));
    }

    @Test
    public void getByStatusClarification() {
        getResponse = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withIds(id)
                )
                        .withFieldNames(
                                WebpageFieldEnum.STATUS_CLARIFICATION)
        );
        assumeThat("вернулся 1 Webpages", getResponse.getWebpages(), iterableWithSize(1));
        assertThat("вернулся ожидаемый Id", getResponse.getWebpages().get(0),
                beanDiffer(
                        (WebpageGetItem) new WebpageGetItemMap()
                                .withStatusClarification(StatusClarification.WEBPAGE_RESUMED.getStatusClarification())
                                .getBean()
                ));
    }

}
