package ru.yandex.autotests.directapi.dynamictextadtargets.get;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.dynamictextadtargets.AddResponse;
import com.yandex.direct.api.v5.dynamictextadtargets.GetResponse;
import com.yandex.direct.api.v5.dynamictextadtargets.StringConditionOperatorEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageConditionOperandEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageFieldEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageConditionMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageGetItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpagesSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by ginger on 16.10.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.GET)
@Description("Проверка фильтрации по Ids")
public class GetIdsTest {
    private static String client = DynamicTextAdTargetsLogins.SINGLE_CLIENT_GET;
    private static Long anotherClientCampaignId = 263l;
    private static Long cid1;
    private static Long pid1;
    private static Long cid2;
    private static Long pid2;
    private static List<Long> webpageIdsOfPid1;
    private static List<Long> webpageIdsOfPid2;
    private GetResponse getResponse;
    private static Long dynamicTextFeedFilterId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);

        cid1 = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid1 = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid1);
        webpageIdsOfPid1 = api.userSteps.dynamicTextAdTargetsSteps().addWebpages(
                new WebpageAddItemMap()
                        .withAdGroupId(pid1)
                        .withConditions(new WebpageConditionMap()
                                .withOperand(WebpageConditionOperandEnum.PAGE_CONTENT)
                                .withOperator(StringConditionOperatorEnum.NOT_CONTAINS_ALL)
                                .withArguments("ginger")
                        )
                        .withName("Name1"),
                new WebpageAddItemMap()
                        .withAdGroupId(pid1)
                        .withConditions(new WebpageConditionMap()
                                .withOperand(WebpageConditionOperandEnum.PAGE_TITLE)
                                .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                                .withArguments("картоха")
                        )
                        .withName("Name2")
        );

        cid2 = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid2 = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid2);
        webpageIdsOfPid2 = api.userSteps.dynamicTextAdTargetsSteps().addWebpages(
                new WebpageAddItemMap()
                        .withAdGroupId(pid2)
                        .withConditions(new WebpageConditionMap()
                                .withOperand(WebpageConditionOperandEnum.PAGE_CONTENT)
                                .withOperator(StringConditionOperatorEnum.NOT_CONTAINS_ALL)
                                .withArguments("ginger")
                        )
                        .withName("Name1")
        );

        Long cid3 = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        Long dynamicTextFeedAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid3);
        dynamicTextFeedFilterId = api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(dynamicTextFeedAdGroupId);
        int shard = api.userSteps.clientFakeSteps().getUserShard(client);
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        Long feedId = jooqDbSteps.feedsSteps().createDefaultFeed(User.get(client).getClientID());
        jooqDbSteps.adGroupsSteps().convertAdgroupDynamicToDynamicByFeed(dynamicTextFeedAdGroupId, feedId);

    }

    @Test
    public void getByOneId() {
        getResponse = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withIds(webpageIdsOfPid1.get(0))
                )
                        .withFieldNames(WebpageFieldEnum.ID)
        );
        assumeThat("вернулся 1 Webpages", getResponse.getWebpages(), iterableWithSize(1));
        assertThat("вернулся ожидаемый Id", getResponse.getWebpages().get(0),
                beanDiffer(
                        (WebpageGetItem) new WebpageGetItemMap().withId(webpageIdsOfPid1.get(0)).getBean()
                ));
    }

    @Test
    public void getBySomeIdsOfOnePid() {
        getResponse = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withIds(webpageIdsOfPid1.get(0), webpageIdsOfPid1.get(1))
                )
                        .withFieldNames(WebpageFieldEnum.ID)
        );
        assumeThat("вернулось 2 Webpages", getResponse.getWebpages(), iterableWithSize(2));
        assertThat("вернулся ожидаемый Webpages", getResponse.getWebpages(),
                beanDiffer(Arrays.asList(
                        (WebpageGetItem) new WebpageGetItemMap().withId(webpageIdsOfPid1.get(0)).getBean(),
                        (WebpageGetItem) new WebpageGetItemMap().withId(webpageIdsOfPid1.get(1)).getBean()
                )));
    }

    @Test
    public void getBySomeIdsOfSomePid() {
        getResponse = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withIds(webpageIdsOfPid1.get(0), webpageIdsOfPid2.get(0))
                )
                        .withFieldNames(WebpageFieldEnum.ID)
        );
        assumeThat("вернулось 2 Webpages", getResponse.getWebpages(), iterableWithSize(2));
        assertThat("вернулся ожидаемый Webpages", getResponse.getWebpages(),
                beanDiffer(Arrays.asList(
                        (WebpageGetItem) new WebpageGetItemMap().withId(webpageIdsOfPid1.get(0)).getBean(),
                        (WebpageGetItem) new WebpageGetItemMap().withId(webpageIdsOfPid2.get(0)).getBean()
                )));
    }

    @Test
    public void getByDuplicatedId() {
        getResponse = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withIds(webpageIdsOfPid1.get(0), webpageIdsOfPid1.get(0))
                )
                        .withFieldNames(WebpageFieldEnum.ID)
        );
        assumeThat("вернулся 1 Webpages", getResponse.getWebpages(), iterableWithSize(1));
        assertThat("вернулся ожидаемый Id", getResponse.getWebpages().get(0),
                beanDiffer(
                        (WebpageGetItem) new WebpageGetItemMap().withId(webpageIdsOfPid1.get(0)).getBean()
                ));
    }

    @Test
    public void getByNonExistentId() {
        getResponse = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withIds(webpageIdsOfPid1.get(0) + 1000)
                )
                        .withFieldNames(WebpageFieldEnum.ID)
        );
        assertThat("вернулась 0 Webpages", getResponse.getWebpages(), hasSize(0));
    }

    @Test
    public void getByZeroId() {
        getResponse = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withIds(0l)
                )
                        .withFieldNames(WebpageFieldEnum.ID)
        );
        assertThat("вернулась 0 Webpages", getResponse.getWebpages(), hasSize(0));
    }

    @Test
    public void getByNegativeId() {
        getResponse = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withIds(-webpageIdsOfPid1.get(0))
                )
                        .withFieldNames(WebpageFieldEnum.ID)
        );
        assertThat("вернулась 0 Webpages", getResponse.getWebpages(), hasSize(0));
    }

    @Test
    public void getByDeletedId() {
        Long campaignID = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign(client);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignID);
        AddResponse response = api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(new WebpageAddItemMap()
                                .withAdGroupId(adGroupId)
                                .withName("Name")
                                .withConditions(new WebpageConditionMap()
                                        .withOperand(WebpageConditionOperandEnum.PAGE_TITLE)
                                        .withOperator(StringConditionOperatorEnum.NOT_CONTAINS_ALL)
                                        .withArguments("ginger")
                                )
                                .withBid(30000000l)
                        ),
                ExpectedResult.success()
        );
        api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsDelete(
                new DeleteRequestMap().withSelectionCriteria(
                        new IdsCriteriaMap().withIds(response.getAddResults().get(0).getId())
                )
        );
        getResponse = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withCampaignIds(campaignID)
                )
                        .withFieldNames(WebpageFieldEnum.ID, WebpageFieldEnum.STATE)
        );
        assertThat("вернулась 0 Webpages", getResponse.getWebpages(), hasSize(0));
    }

    @Test
    public void getAnotherClientId() {
        getResponse = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withIds(anotherClientCampaignId)
                )
                        .withFieldNames(WebpageFieldEnum.ID)
        );
        assertThat("вернулась 0 Webpages", getResponse.getWebpages(), hasSize(0));
    }

    @Test
    public void getByDynamicTextFeedFilterId() {
        getResponse = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withIds(dynamicTextFeedFilterId)
                )
                        .withFieldNames(WebpageFieldEnum.ID)
        );
        assertThat("вернулась 0 Webpages", getResponse.getWebpages(), hasSize(0));
    }
}
