package ru.yandex.autotests.directapi.dynamictextadtargets.get;

import com.yandex.direct.api.v5.dynamictextadtargets.WebpageFieldEnum;
import com.yandex.direct.api.v5.general.AdTargetStateSelectionEnum;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpagesSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.LimitOffsetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by ginger on 30.10.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.GET)
@Description("Проверка невалидного типа полей метода Get")
public class GetInvalidTypesOfFieldsTest {
    private static String client = DynamicTextAdTargetsLogins.SINGLE_CLIENT_GET;
    private static Integer intValue = 123;
    private static String stringValue = "usual string";
    private static Long cid;
    private static Long pid;
    private static Long id;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);

        cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        id = api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
    }


    @Test
    public void invalidTypeOfSelectionCriteria() {
        JSONObject request = new JSONObject();
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), intValue);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{WebpageFieldEnum.ID});
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.INVALID_VALUE,
                        capitalize(GetRequestMap.SELECTION_CRITERIA))
        );
    }

    @Test
    public void invalidTypeOfFieldNames() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(WebpagesSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), intValue);
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        capitalize(GetRequestMap.FIELD_NAMES))
        );
    }

    @Test
    public void invalidTypeInPage() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(WebpagesSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{WebpageFieldEnum.ID});
        request.put(capitalize(GetRequestMap.PAGE), intValue);
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.INVALID_VALUE,
                        capitalize(GetRequestMap.PAGE))
        );
    }

    @Test
    public void invalidTypeOfLimit() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        JSONObject page = new JSONObject();
        selectionCriteria.put(capitalize(WebpagesSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{WebpageFieldEnum.ID});
        page.put(capitalize(LimitOffsetMap.LIMIT), stringValue);
        request.put(capitalize(GetRequestMap.PAGE), page);
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                        path(capitalize(GetRequestMap.PAGE), capitalize(LimitOffsetMap.LIMIT)))
        );
    }

    @Test
    public void invalidTypeOfOffset() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        JSONObject page = new JSONObject();
        selectionCriteria.put(capitalize(WebpagesSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{WebpageFieldEnum.ID});
        page.put(capitalize(LimitOffsetMap.OFFSET), stringValue);
        request.put(capitalize(GetRequestMap.PAGE), page);
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                        path(capitalize(GetRequestMap.PAGE), capitalize(LimitOffsetMap.OFFSET)))
        );
    }

    @Test
    public void invalidTypeInIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(WebpagesSelectionCriteriaMap.IDS), new String[]{stringValue});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{WebpageFieldEnum.ID});
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                        path(capitalize(GetRequestMap.SELECTION_CRITERIA),
                                capitalize(WebpagesSelectionCriteriaMap.IDS)))
        );
    }

    @Test
    public void invalidTypeInAdGroupIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(WebpagesSelectionCriteriaMap.AD_GROUP_IDS), new String[]{stringValue});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{WebpageFieldEnum.ID});
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                        path(capitalize(GetRequestMap.SELECTION_CRITERIA),
                                capitalize(WebpagesSelectionCriteriaMap.AD_GROUP_IDS)))
        );
    }

    @Test
    public void invalidTypeInCampaignIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(WebpagesSelectionCriteriaMap.CAMPAIGN_IDS), new String[]{stringValue});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{WebpageFieldEnum.ID});
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                        path(capitalize(GetRequestMap.SELECTION_CRITERIA),
                                capitalize(WebpagesSelectionCriteriaMap.CAMPAIGN_IDS)))
        );
    }

    @Test
    public void invalidTypeInStates() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(WebpagesSelectionCriteriaMap.IDS), new Long[]{id});
        selectionCriteria.put(capitalize(WebpagesSelectionCriteriaMap.STATES), new Integer[]{intValue});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{WebpageFieldEnum.ID});
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        path(capitalize(GetRequestMap.SELECTION_CRITERIA),
                                capitalize(WebpagesSelectionCriteriaMap.STATES)),
                        String.join(", ",
                                AdTargetStateSelectionEnum.ON.value(),
                                AdTargetStateSelectionEnum.OFF.value(),
                                AdTargetStateSelectionEnum.SUSPENDED.value(),
                                AdTargetStateSelectionEnum.DELETED.value()
                        ))
        );
    }

}
