package ru.yandex.autotests.directapi.dynamictextadtargets.get;

import com.yandex.direct.api.v5.dynamictextadtargets.WebpageFieldEnum;
import com.yandex.direct.api.v5.general.AdTargetStateSelectionEnum;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpagesSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.LimitOffsetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by ginger on 21.10.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.GET)
@Description("Проверка невалидной стуктуры полей метода Get")
public class GetJsonValidationTest {
    private static String client = DynamicTextAdTargetsLogins.SINGLE_CLIENT_GET;
    private static final String PARAMS = "params";
    private static Long cid;
    private static Long pid;
    private static Long id;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);

        cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        id = api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
    }

    @Test
    public void invalidFieldInParams() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(WebpagesSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(GetRequestMap.SELECTION_CRITERIA, selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{WebpageFieldEnum.ID});
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.UNKNOWN_PARAMETER,
                        GetRequestMap.SELECTION_CRITERIA)
        );
    }

    @Test
    public void invalidFieldInSelectionCriteria() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(WebpagesSelectionCriteriaMap.IDS), new Long[]{id});
        selectionCriteria.put(WebpagesSelectionCriteriaMap.IDS, new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{WebpageFieldEnum.ID});
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.UNKNOWN_PARAMETER,
                        String.join(".", capitalize(GetRequestMap.SELECTION_CRITERIA),
                                WebpagesSelectionCriteriaMap.IDS))
        );
    }

    @Test
    public void invalidFieldInPage() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        JSONObject page = new JSONObject();
        selectionCriteria.put(capitalize(WebpagesSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{WebpageFieldEnum.ID});
        page.put(LimitOffsetMap.LIMIT, 1l);
        request.put(capitalize(GetRequestMap.PAGE), page);
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.UNKNOWN_PARAMETER,
                        String.join(".", capitalize(GetRequestMap.PAGE), LimitOffsetMap.LIMIT))
        );
    }

    @Test
    public void arrayInParams() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(WebpagesSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{WebpageFieldEnum.ID});
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsGet(
                new Object[]{request},
                new Api5Error(8000, Api5ErrorDetailsJava.INVALID_REQUEST_FORMAT)
        );
    }

    @Test
    public void arrayInSelectionCriteria() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(WebpagesSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), new Object[]{selectionCriteria});
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{WebpageFieldEnum.ID});
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        capitalize(GetRequestMap.SELECTION_CRITERIA))
        );
    }

    @Test
    public void arrayInPage() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        JSONObject page = new JSONObject();
        selectionCriteria.put(capitalize(WebpagesSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{WebpageFieldEnum.ID});
        page.put(capitalize(LimitOffsetMap.LIMIT), 1l);
        request.put(capitalize(GetRequestMap.PAGE), new Object[]{page});
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        capitalize(GetRequestMap.PAGE))
        );
    }

    @Test
    public void arrayInLimit() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        JSONObject page = new JSONObject();
        selectionCriteria.put(capitalize(WebpagesSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{WebpageFieldEnum.ID});
        page.put(capitalize(LimitOffsetMap.LIMIT), new Object[]{1l});
        request.put(capitalize(GetRequestMap.PAGE), page);
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(capitalize(GetRequestMap.PAGE), capitalize(LimitOffsetMap.LIMIT)))
        );
    }

    @Test
    public void arrayInOffset() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        JSONObject page = new JSONObject();
        selectionCriteria.put(capitalize(WebpagesSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{WebpageFieldEnum.ID});
        page.put(capitalize(LimitOffsetMap.LIMIT), 1l);
        page.put(capitalize(LimitOffsetMap.OFFSET), new Object[]{1l});
        request.put(capitalize(GetRequestMap.PAGE), page);
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(capitalize(GetRequestMap.PAGE), capitalize(LimitOffsetMap.OFFSET)))
        );
    }

    @Test
    public void notArrayInFieldNames() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(WebpagesSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), WebpageFieldEnum.ID);
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        capitalize(GetRequestMap.FIELD_NAMES))
        );
    }

    @Test
    public void invalidValueInFieldNames() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(WebpagesSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new String[]{WebpageFieldEnum.ID.value(),
                AdTargetStateSelectionEnum.SUSPENDED.value()});
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        capitalize(GetRequestMap.FIELD_NAMES),
                        String.join(", ",
                                WebpageFieldEnum.AD_GROUP_ID.value(),
                                WebpageFieldEnum.BID.value(),
                                WebpageFieldEnum.CAMPAIGN_ID.value(),
                                WebpageFieldEnum.CONDITIONS.value(),
                                WebpageFieldEnum.CONDITION_TYPE.value(),
                                WebpageFieldEnum.CONTEXT_BID.value(),
                                WebpageFieldEnum.ID.value(),
                                WebpageFieldEnum.NAME.value(),
                                WebpageFieldEnum.STATE.value(),
                                WebpageFieldEnum.STATUS_CLARIFICATION.value(),
                                WebpageFieldEnum.STRATEGY_PRIORITY.value()
                        ))
        );
    }

    @Test
    public void notArrayInIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(WebpagesSelectionCriteriaMap.IDS), id);
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{WebpageFieldEnum.ID});
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(capitalize(GetRequestMap.SELECTION_CRITERIA),
                                capitalize(WebpagesSelectionCriteriaMap.IDS)))
        );
    }


    @Test
    public void notArrayInAdGroupIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(WebpagesSelectionCriteriaMap.AD_GROUP_IDS), pid);
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{WebpageFieldEnum.ID});
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(capitalize(GetRequestMap.SELECTION_CRITERIA),
                                capitalize(WebpagesSelectionCriteriaMap.AD_GROUP_IDS)))
        );
    }


    @Test
    public void notArrayInCampaignIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(WebpagesSelectionCriteriaMap.CAMPAIGN_IDS), cid);
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{WebpageFieldEnum.ID});
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(capitalize(GetRequestMap.SELECTION_CRITERIA),
                                capitalize(WebpagesSelectionCriteriaMap.CAMPAIGN_IDS)))
        );
    }


    @Test
    public void notArrayInStates() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(WebpagesSelectionCriteriaMap.IDS), new Long[]{id});
        selectionCriteria.put(capitalize(WebpagesSelectionCriteriaMap.STATES), AdTargetStateSelectionEnum.OFF);
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{WebpageFieldEnum.ID});
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        capitalize(WebpagesSelectionCriteriaMap.STATES))
        );
    }

    @Test
    public void invalidValueInStates() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(WebpagesSelectionCriteriaMap.IDS), new Long[]{id});
        selectionCriteria.put(capitalize(WebpagesSelectionCriteriaMap.STATES), new String[]{"UNKNOWN"});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{WebpageFieldEnum.ID});
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        capitalize(WebpagesSelectionCriteriaMap.STATES))
        );
    }
}
