package ru.yandex.autotests.directapi.dynamictextadtargets.get;

import java.util.Arrays;

import com.yandex.direct.api.v5.dynamictextadtargets.WebpageFieldEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpagesSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlApi5Error;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by ginger on 23.10.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.GET)
@Description("Негативная проверка ограничений в SelectionCriteria.")
public class GetLimitNegativeTest {
    private static String client = DynamicTextAdTargetsLogins.SINGLE_CLIENT_GET;
    private static Long cid;
    private static Long pid;
    private static Long id;
    private Integer IDS_LIMIT = 10000;
    private Integer AD_GROUPS_LIMIT = 1000;
    private Integer CAMPAIGN_IDS_LIMIT = 2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);

        cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        id = api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
    }

    @Before
    public void addUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        api.as(client);
    }


    @Test
    public void getWithMoreThanMaxIdsInSelectionCriteria() {
        Long[] IDs = new Long[IDS_LIMIT + 1];
        Arrays.fill(IDs, id);
        Api5Error perlError = new Api5Error(4001,
                Api5ErrorDetails.ARRAY_CANNOT_CONTAIN_MORE_THAN,
                capitalize(WebpagesSelectionCriteriaMap.IDS),
                IDS_LIMIT

        );
        Api5Error javaError = new Api5Error(4001,
                Api5ErrorDetails.ARRAY_CANNOT_CONTAIN_MORE_THAN,
                path(capitalize(GetRequestMap.SELECTION_CRITERIA),
                        capitalize(WebpagesSelectionCriteriaMap.IDS)),
                IDS_LIMIT

        );
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new WebpagesSelectionCriteriaMap()
                                        .withIds(IDs))
                        .withFieldNames(WebpageFieldEnum.ID),
                JavaOrPerlApi5Error
                        .java(javaError)
                        .perl(perlError)
        );
    }

    @Test
    public void getWithMoreThanMaxAdGroupIdsInSelectionCriteria() {
        Long[] IDs = new Long[AD_GROUPS_LIMIT + 1];
        Arrays.fill(IDs, pid);
        Api5Error perlError = new Api5Error(4001,
                Api5ErrorDetails.ARRAY_CANNOT_CONTAIN_MORE_THAN,
                capitalize(WebpagesSelectionCriteriaMap.AD_GROUP_IDS),
                AD_GROUPS_LIMIT

        );
        Api5Error javaError = new Api5Error(4001,
                Api5ErrorDetails.ARRAY_CANNOT_CONTAIN_MORE_THAN,
                path(capitalize(GetRequestMap.SELECTION_CRITERIA),
                        capitalize(WebpagesSelectionCriteriaMap.AD_GROUP_IDS)),
                AD_GROUPS_LIMIT

        );
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new WebpagesSelectionCriteriaMap()
                                        .withAdGroupIds(IDs))
                        .withFieldNames(WebpageFieldEnum.ID),
                JavaOrPerlApi5Error
                        .java(javaError)
                        .perl(perlError)
        );
    }


    @Test
    public void getWithMoreThanMaxCampaignIdsInSelectionCriteria() {
        Long[] IDs = new Long[CAMPAIGN_IDS_LIMIT + 1];
        Arrays.fill(IDs, cid);
        Api5Error perlError = new Api5Error(4001,
                Api5ErrorDetails.ARRAY_CANNOT_CONTAIN_MORE_THAN,
                capitalize(WebpagesSelectionCriteriaMap.CAMPAIGN_IDS),
                CAMPAIGN_IDS_LIMIT
        );
        Api5Error javaError = new Api5Error(4001,
                Api5ErrorDetails.ARRAY_CANNOT_CONTAIN_MORE_THAN,
                path(capitalize(GetRequestMap.SELECTION_CRITERIA),
                        capitalize(WebpagesSelectionCriteriaMap.CAMPAIGN_IDS)),
                CAMPAIGN_IDS_LIMIT
        );

        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new WebpagesSelectionCriteriaMap()
                                        .withCampaignIds(IDs))
                        .withFieldNames(WebpageFieldEnum.ID),
                JavaOrPerlApi5Error
                        .java(javaError)
                        .perl(perlError)
        );
    }
}
