package ru.yandex.autotests.directapi.dynamictextadtargets.get;

import java.util.Arrays;

import com.yandex.direct.api.v5.dynamictextadtargets.GetResponse;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageFieldEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpagesSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 23.10.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.GET)
@Description("Позитивная проверка ограничений в SelectionCriteria.")
public class GetLimitPositiveTest {
    private static String client = DynamicTextAdTargetsLogins.SINGLE_CLIENT_GET;
    private static Long cid;
    private static Long pid;
    private static Long id;
    private Integer IDS_LIMIT = 10000;
    private Integer AD_GROUPS_LIMIT = 1000;
    private Integer CAMPAIGN_IDS_LIMIT = 2;
    private GetResponse getResponse;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);

        cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        id = api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
    }

    @Test
    public void getWithMaxIdsInSelectionCriteria() {
        Long[] IDs = new Long[IDS_LIMIT];
        Arrays.fill(IDs, id);
        getResponse =  api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withIds(IDs)
                )
                        .withFieldNames(
                                WebpageFieldEnum.ID)
        );
        assertThat("вернулся 1 Webpages", getResponse.getWebpages(), hasSize(1));
    }


    @Test
    public void getWithMaxAdGroupIdsInSelectionCriteria() {
        Long[] IDs = new Long[AD_GROUPS_LIMIT];
        Arrays.fill(IDs, pid);
        getResponse =  api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withAdGroupIds(IDs)
                )
                        .withFieldNames(
                                WebpageFieldEnum.AD_GROUP_ID)
        );
        assertThat("вернулся 1 Webpages", getResponse.getWebpages(), hasSize(1));
    }


    @Test
    public void getWithMaxCampaignIdsInSelectionCriteria() {
        Long[] IDs = new Long[CAMPAIGN_IDS_LIMIT];
        Arrays.fill(IDs, cid);
        getResponse =  api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withCampaignIds(IDs)
                )
                        .withFieldNames(
                                WebpageFieldEnum.ID)
        );
        assertThat("вернулся 1 Webpages", getResponse.getWebpages(), hasSize(1));
    }
}
