package ru.yandex.autotests.directapi.dynamictextadtargets.get;

import com.yandex.direct.api.v5.dynamictextadtargets.WebpageFieldEnum;
import com.yandex.direct.api.v5.general.AdTargetStateSelectionEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpagesSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by ginger on 26.10.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.GET)
@Description("Проверка обязательных полей метода Get")
public class GetMandatoryFieldsTest {
    private static String client = DynamicTextAdTargetsLogins.SINGLE_CLIENT_GET;
    private static final String PARAMS = "params";
    private static Long cid;
    private static Long pid;
    private static Long id;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);

        cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        id = api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
    }

    @Test
    public void getWithoutSelectionCriteria() {
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsGet(
                new GetRequestMap()
                        .withFieldNames(WebpageFieldEnum.ID),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(GetRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    public void getWithoutFieldNames() {
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new WebpagesSelectionCriteriaMap()
                                        .withIds(id)),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(GetRequestMap.FIELD_NAMES)));
    }

    @Test
    public void getWithEmptyArrayOfFieldNames() {
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new WebpagesSelectionCriteriaMap()
                                        .withIds(id))
                        .withFieldNames(new WebpageFieldEnum[]{}),
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
                        capitalize(GetRequestMap.FIELD_NAMES), 1));
    }

    @Test
    public void getWithoutIds() {
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new WebpagesSelectionCriteriaMap()
                                        .withStates(AdTargetStateSelectionEnum.OFF))
                        .withFieldNames(WebpageFieldEnum.STATE),
                new Api5Error(4001, Api5ErrorDetails.AT_LEAST_ONE_OF_FOLLOWING_FIELDS_SHOULD_BE_SET));
    }
}
