package ru.yandex.autotests.directapi.dynamictextadtargets.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.dynamictextadtargets.GetResponse;
import com.yandex.direct.api.v5.dynamictextadtargets.StringConditionOperatorEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageConditionOperandEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageFieldEnum;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageConditionMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpagesSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 25.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
        */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.ADD)
@RunWith(Parameterized.class)
@Description("Получение условий от имени внутренних ролей")
public class GetRoleTest {
    private static LogSteps log = LogSteps.getLogger(GetRoleTest.class);

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String webpageCreator;

    @Parameterized.Parameter(1)
    public String webpageGetter;

    @Parameterized.Parameter(2)
    public String client;

    @Parameterized.Parameter(3)
    public Matcher expectedResult;
    private int shard;
    private Long cid;
    private Long pid;
    private Long webpageID;

    @Parameterized.Parameters(name = "creator = {0}, getter = {1}, client = {2}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {Logins.MANAGER_DEFAULT, Logins.MANAGER_DEFAULT, DynamicTextAdTargetsLogins.SERV_CLIENT,
                        hasSize(1)},
                {DynamicTextAdTargetsLogins.AGENCY, DynamicTextAdTargetsLogins.AGENCY, DynamicTextAdTargetsLogins.SUBCLIENT,
                        hasSize(1)},
                {DynamicTextAdTargetsLogins.AGENCY_REP, DynamicTextAdTargetsLogins.AGENCY_REP, DynamicTextAdTargetsLogins.SUBCLIENT,
                        hasSize(1)},
                {DynamicTextAdTargetsLogins.AGENCY, DynamicTextAdTargetsLogins.AGENCY_REP, DynamicTextAdTargetsLogins.SUBCLIENT,
                        hasSize(1)},
                {DynamicTextAdTargetsLogins.AGENCY, DynamicTextAdTargetsLogins.SUBCLIENT, DynamicTextAdTargetsLogins.SUBCLIENT,
                        hasSize(1)},

                {Logins.SUPER_LOGIN, Logins.PLACER, DynamicTextAdTargetsLogins.SINGLE_CLIENT_GET,
                        hasSize(1)},
                {Logins.SUPER_LOGIN, Logins.SUPPORT, DynamicTextAdTargetsLogins.SINGLE_CLIENT_GET,
                        hasSize(1)},
                {Logins.SUPER_LOGIN, Logins.SUPER_LOGIN, DynamicTextAdTargetsLogins.SINGLE_CLIENT_GET,
                        hasSize(1)},
                {Logins.SUPER_LOGIN, DynamicTextAdTargetsLogins.SINGLE_CLIENT_GET, DynamicTextAdTargetsLogins.SINGLE_CLIENT_GET,
                        hasSize(1)},
                {Logins.SUPER_LOGIN, DynamicTextAdTargetsLogins.SINGLE_CLIENT_REP, DynamicTextAdTargetsLogins.SINGLE_CLIENT,
                        hasSize(1)},
                {Logins.SUPER_LOGIN, Logins.MEDIA, DynamicTextAdTargetsLogins.SINGLE_CLIENT_GET,
                        hasSize(1)},
                {Logins.SUPER_LOGIN, Logins.SUPER_READER, DynamicTextAdTargetsLogins.SINGLE_CLIENT_GET,
                        hasSize(1)}
        });
    }

    @Before
    @Step("Подготовка данных для теста")
    public void prepareGroup() {
        log.info("Сбросим использованные юниты");
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(webpageGetter);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(webpageCreator);

        log.info("Создадим кампанию, группу и условие от имени " + webpageCreator);
        api.as(webpageCreator);
        shard = api.userSteps.clientFakeSteps().getUserShard(client);
        cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign(client);
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid,client);
        webpageID = api.userSteps.dynamicTextAdTargetsSteps().addWebpage(
                        new WebpageAddItemMap()
                                .withAdGroupId(pid)
                                .withConditions(new WebpageConditionMap()
                                        .withOperand(WebpageConditionOperandEnum.PAGE_CONTENT)
                                        .withOperator(StringConditionOperatorEnum.NOT_CONTAINS_ALL)
                                        .withArguments("ginger")
                                )
                                .withName("Name1"),
                client
                );
    }

    @Test
    public void getRolesTest() {
        log.info("Запросим условие от имени " + webpageGetter);
        api.as(webpageGetter);
        GetResponse webpages = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(new WebpagesSelectionCriteriaMap().withIds(webpageID)).withFieldNames(WebpageFieldEnum.ID),
                client);
        assertThat("получили условие ролью", webpages.getWebpages(), expectedResult);
    }
}
