package ru.yandex.autotests.directapi.dynamictextadtargets.get;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.dynamictextadtargets.GetResponse;
import com.yandex.direct.api.v5.dynamictextadtargets.StringConditionOperatorEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageConditionOperandEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageFieldEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageGetItem;
import com.yandex.direct.api.v5.general.AdTargetStateSelectionEnum;
import com.yandex.direct.api.v5.general.StateEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.StatusClarification;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageConditionMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageGetItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpagesSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by ginger on 27.10.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.GET)
@Description("Проверка фильтрации по States")
public class GetStatesAndStatusClarificationTest {
    private static String client = DynamicTextAdTargetsLogins.SINGLE_CLIENT_GET;
    private static int shard;
    private static Long cid;
    private static Long pid;
    private static List<Long> webpagesOfPid;
    private static Long deletedWebpageId;
    private static Long suspendedWebpageId;
    private static Long onWebpageId;
    private static Long offWithStatusBsSyncedNoWebpageId;
    private static Long offWithStatusBsSyncedSendingWebpageId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);
    private GetResponse getResponse;

    @BeforeClass
    public static void initTest() {
        shard = api.userSteps.clientFakeSteps().getUserShard(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);

        cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        webpagesOfPid = api.userSteps.dynamicTextAdTargetsSteps().addWebpages(
                        new WebpageAddItemMap()
                                .withAdGroupId(pid)
                                .withConditions(new WebpageConditionMap()
                                        .withOperand(WebpageConditionOperandEnum.PAGE_CONTENT)
                                        .withOperator(StringConditionOperatorEnum.NOT_CONTAINS_ALL)
                                        .withArguments("ginger")
                                )
                                .withName("Name1"),
                        new WebpageAddItemMap()
                                .withAdGroupId(pid)
                                .withConditions(new WebpageConditionMap()
                                        .withOperand(WebpageConditionOperandEnum.PAGE_CONTENT)
                                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                                        .withArguments("direct")
                                )
                                .withName("Name2"),
                        new WebpageAddItemMap()
                                .withAdGroupId(pid)
                                .withConditions(new WebpageConditionMap()
                                        .withOperand(WebpageConditionOperandEnum.PAGE_TITLE)
                                        .withOperator(StringConditionOperatorEnum.NOT_CONTAINS_ALL)
                                        .withArguments("ginger")
                                )
                                .withName("Name3"),
                        new WebpageAddItemMap()
                                .withAdGroupId(pid)
                                .withConditions(new WebpageConditionMap()
                                        .withOperand(WebpageConditionOperandEnum.PAGE_TITLE)
                                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                                        .withArguments("direct")
                                )
                                .withName("Name4"),
                        new WebpageAddItemMap()
                                .withAdGroupId(pid)
                                .withConditions(new WebpageConditionMap()
                                        .withOperand(WebpageConditionOperandEnum.PAGE_TITLE)
                                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                                        .withArguments("direct.api")
                                )
                                .withName("Name5")
        );
        deletedWebpageId = webpagesOfPid.get(0);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bidsDynamicSteps()
                .deleteBidsDynamicIdsByDynCondId(pid, deletedWebpageId);
        suspendedWebpageId = webpagesOfPid.get(1);
        api.userSteps.getDirectJooqDbSteps().bidsDynamicSteps().setSuspended(pid, suspendedWebpageId);
        onWebpageId = webpagesOfPid.get(2);
        offWithStatusBsSyncedNoWebpageId = webpagesOfPid.get(3);
        offWithStatusBsSyncedSendingWebpageId = webpagesOfPid.get(4);
    }

    @Before
    public void addUnits(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    public void getByAllStates() {
        getResponse =  api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withIds(
                                        deletedWebpageId,
                                        suspendedWebpageId,
                                        onWebpageId,
                                        offWithStatusBsSyncedNoWebpageId,
                                        offWithStatusBsSyncedSendingWebpageId
                                        )
                        .withStates(
                                AdTargetStateSelectionEnum.ON,
                                AdTargetStateSelectionEnum.DELETED,
                                AdTargetStateSelectionEnum.OFF,
                                AdTargetStateSelectionEnum.SUSPENDED
                        )
                )
                        .withFieldNames(
                                WebpageFieldEnum.STATE, WebpageFieldEnum.STATUS_CLARIFICATION, WebpageFieldEnum.ID)
        );
        assumeThat("вернулось 5 Webpages", getResponse.getWebpages(), iterableWithSize(5));
        assertThat("вернулся ожидаемый Id", getResponse.getWebpages(),
                beanDiffer( Arrays.asList(
                        (WebpageGetItem) new WebpageGetItemMap()
                                .withId(deletedWebpageId)
                                .withState(StateEnum.DELETED)
                                .withStatusClarification(StatusClarification.WEBPAGE_DELETED.getStatusClarification())
                                .getBean(),
                        (WebpageGetItem) new WebpageGetItemMap()
                                .withId(suspendedWebpageId)
                                .withState(StateEnum.SUSPENDED)
                                .withStatusClarification(StatusClarification.WEBPAGE_SUSPENDED.getStatusClarification())
                                .getBean(),
                        (WebpageGetItem) new WebpageGetItemMap()
                                .withId(onWebpageId)
                                .withState(StateEnum.ON)
                                .withStatusClarification(StatusClarification.WEBPAGE_RESUMED.getStatusClarification())
                                .getBean(),
                        (WebpageGetItem) new WebpageGetItemMap()
                                .withId(offWithStatusBsSyncedNoWebpageId)
                                .withState(StateEnum.ON)
                                .withStatusClarification(StatusClarification.WEBPAGE_RESUMED.getStatusClarification())
                                .getBean(),
                        (WebpageGetItem) new WebpageGetItemMap()
                                .withId(offWithStatusBsSyncedSendingWebpageId)
                                .withState(StateEnum.ON)
                                .withStatusClarification(StatusClarification.WEBPAGE_RESUMED.getStatusClarification())
                                .getBean()

                )));
    }

    @Test
    public void getByOnState() {
        getResponse =  api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withIds(onWebpageId)
                                .withStates(
                                        AdTargetStateSelectionEnum.ON
                                )
                )
                        .withFieldNames(
                                WebpageFieldEnum.STATE, WebpageFieldEnum.STATUS_CLARIFICATION, WebpageFieldEnum.ID)
        );
        assumeThat("вернулся 1 Webpages", getResponse.getWebpages(), iterableWithSize(1));
        assertThat("вернулся ожидаемый Id", getResponse.getWebpages().get(0),
                beanDiffer(
                        (WebpageGetItem) new WebpageGetItemMap()
                                .withId(onWebpageId)
                                .withState(StateEnum.ON)
                                .withStatusClarification(StatusClarification.WEBPAGE_RESUMED.getStatusClarification())
                                .getBean()
                ));
    }

    @Test
    public void getByDeletedState() {
        getResponse =  api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withIds(deletedWebpageId)
                                .withStates(
                                        AdTargetStateSelectionEnum.DELETED
                                )
                )
                        .withFieldNames(
                                WebpageFieldEnum.STATE, WebpageFieldEnum.STATUS_CLARIFICATION, WebpageFieldEnum.ID)
        );
        assumeThat("вернулся 1 Webpages", getResponse.getWebpages(), iterableWithSize(1));
        assertThat("вернулся ожидаемый Id", getResponse.getWebpages().get(0),
                beanDiffer(
                        (WebpageGetItem) new WebpageGetItemMap()
                                .withId(deletedWebpageId)
                                .withState(StateEnum.DELETED)
                                .withStatusClarification(StatusClarification.WEBPAGE_DELETED.getStatusClarification())
                                .getBean()
                ));
    }

    @Test
    public void getByOffStateWithStatusBsSyncedNo() {
        getResponse =  api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withIds(offWithStatusBsSyncedNoWebpageId)
                                .withStates(
                                        AdTargetStateSelectionEnum.OFF
                                )
                )
                        .withFieldNames(
                                WebpageFieldEnum.STATE, WebpageFieldEnum.STATUS_CLARIFICATION, WebpageFieldEnum.ID)
        );
        assumeThat("вернулся 1 Webpages", getResponse.getWebpages(), iterableWithSize(1));
        assertThat("вернулся ожидаемый Id", getResponse.getWebpages().get(0),
                beanDiffer(
                        (WebpageGetItem) new WebpageGetItemMap()
                                .withId(offWithStatusBsSyncedNoWebpageId)
                                .withState(StateEnum.ON)
                                .withStatusClarification(StatusClarification.WEBPAGE_RESUMED.getStatusClarification())
                                .getBean()
                ));
    }

    @Test
    public void getByOffStateWithStatusBsSyncedSending() {
        getResponse =  api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withIds(offWithStatusBsSyncedSendingWebpageId)
                                .withStates(
                                        AdTargetStateSelectionEnum.OFF
                                )
                )
                        .withFieldNames(
                                WebpageFieldEnum.STATE, WebpageFieldEnum.STATUS_CLARIFICATION, WebpageFieldEnum.ID)
        );
        assumeThat("вернулся 1 Webpages", getResponse.getWebpages(), iterableWithSize(1));
        assertThat("вернулся ожидаемый Id", getResponse.getWebpages().get(0),
                beanDiffer(
                        (WebpageGetItem) new WebpageGetItemMap()
                                .withId(offWithStatusBsSyncedSendingWebpageId)
                                .withState(StateEnum.ON)
                                .withStatusClarification(StatusClarification.WEBPAGE_RESUMED.getStatusClarification())
                                .getBean()
                ));
    }

    @Test
    public void getBySuspendState() {
        getResponse =  api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(
                        new WebpagesSelectionCriteriaMap()
                                .withIds(suspendedWebpageId)
                                .withStates(
                                        AdTargetStateSelectionEnum.SUSPENDED
                                )
                )
                        .withFieldNames(
                                WebpageFieldEnum.STATE, WebpageFieldEnum.STATUS_CLARIFICATION, WebpageFieldEnum.ID)
        );
        assumeThat("вернулся 1 Webpages", getResponse.getWebpages(), iterableWithSize(1));
        assertThat("вернулся ожидаемый Id", getResponse.getWebpages().get(0),
                beanDiffer(
                        (WebpageGetItem) new WebpageGetItemMap()
                                .withId(suspendedWebpageId)
                                .withState(StateEnum.SUSPENDED)
                                .withStatusClarification(StatusClarification.WEBPAGE_SUSPENDED.getStatusClarification())
                                .getBean()
                ));
    }
}
