package ru.yandex.autotests.directapi.dynamictextadtargets.get;

import com.sun.xml.ws.util.StringUtils;
import com.yandex.direct.api.v5.dynamictextadtargets.StringConditionOperatorEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageConditionOperandEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageFieldEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageConditionMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpagesSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 25.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.GET)
@Description("Проверка в Get списания баллов")
public class GetUnitsTest {
    private static LogSteps log = LogSteps.getLogger(GetUnitsTest.class);
    private static final String singleClient = DynamicTextAdTargetsLogins.UNITS_GET_CLIENT;
    private static final String agency = DynamicTextAdTargetsLogins.AGENCY_UNITS_GET;
    private static final String subclient = DynamicTextAdTargetsLogins.SUBCLIENT_UNITS_GET;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long singleClientCid;
    private static Long agencyCid;

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final int GET_COST = 15;
    private static final int ITEM_COST_ON_GET = 1;
    private static final int GENERAL_FAULT_COST = 50;
    private Long singleClientPid;
    private Long agencyPid;
    private Long singleCliebtWebpageID1;
    private Long singleCliebtWebpageID2;
    private Long agencyWebpageID1;
    private Long agencyWebpageID2;


    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agency);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(singleClient);
        singleClientCid = api.as(singleClient).userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        singleClientPid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(singleClientCid, singleClient);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(singleClient);
        singleCliebtWebpageID1 = api.userSteps.dynamicTextAdTargetsSteps().addWebpage(
                new WebpageAddItemMap()
                        .withAdGroupId(singleClientPid)
                        .withName("Name")
                        .withConditions(
                                new WebpageConditionMap()
                                        .withArguments("картоха")
                                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                                        .withOperand(WebpageConditionOperandEnum.PAGE_CONTENT)
                        )
                        .withBid(30000000l)
        );
        singleCliebtWebpageID2 = api.userSteps.dynamicTextAdTargetsSteps().addWebpage(
                new WebpageAddItemMap()
                        .withAdGroupId(singleClientPid)
                        .withName("Name")
                        .withConditions(
                                new WebpageConditionMap()
                                        .withArguments("картоха")
                                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                                        .withOperand(WebpageConditionOperandEnum.PAGE_TITLE)
                        )
                        .withBid(30000000l)
        );
    }

    @Test
    @Description("Получение одиночного условия")
    public void getSingleWebpageTest() {
        api.as(singleClient);
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(singleClient);
        api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet( new GetRequestMap().withSelectionCriteria(
                new WebpagesSelectionCriteriaMap()
                        .withIds(singleCliebtWebpageID1))
                        .withFieldNames(
                                WebpageFieldEnum.ID));
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(singleClient);
        assertThat("стоимость получения одного условия", unitsBefore - unitsAfter, equalTo(GET_COST + ITEM_COST_ON_GET));
    }

    @Test
    @Description("Получение нескольких условий")
    public void getSeveralWebpagesTest() {
        api.as(singleClient);
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(singleClient);
        api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(new GetRequestMap().withSelectionCriteria(
                new WebpagesSelectionCriteriaMap()
                        .withIds(singleCliebtWebpageID1, singleCliebtWebpageID2))
                .withFieldNames(
                        WebpageFieldEnum.ID));
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(singleClient);

        assertThat("стоимость получения двух условий", unitsBefore - unitsAfter, equalTo(GET_COST + ITEM_COST_ON_GET * 2));
    }

    @Test
    @Description("Получение условия по AdGroupId")
    public void getWebpageByGroupIDTest() {
        api.as(singleClient);
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(singleClient);
        api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(new GetRequestMap().withSelectionCriteria(
                new WebpagesSelectionCriteriaMap()
                        .withAdGroupIds(singleClientPid))
                .withFieldNames(
                        WebpageFieldEnum.ID));
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(singleClient);
        assertThat("стоимость получения одного условий", unitsBefore - unitsAfter, equalTo(GET_COST + ITEM_COST_ON_GET * 2));
    }

    @Test
    @Description("Получение условия по CampaignId")
    public void getWebpageByCampaignIDTest() {
        api.as(singleClient);
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(singleClient);
        api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(new GetRequestMap().withSelectionCriteria(
                new WebpagesSelectionCriteriaMap()
                        .withCampaignIds(singleClientCid))
                .withFieldNames(
                        WebpageFieldEnum.ID));
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(singleClient);
        assertThat("стоимость получения одного условий", unitsBefore - unitsAfter, equalTo(GET_COST + ITEM_COST_ON_GET * 2));
    }

    @Test
    @Description("Запрос несуществующего условия")
    public void getNonExistingWebpageTest() {
        api.as(singleClient);
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(singleClient);
        api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(new GetRequestMap().withSelectionCriteria(
                new WebpagesSelectionCriteriaMap()
                        .withIds(1l))
                .withFieldNames(
                        WebpageFieldEnum.ID));
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(singleClient);

        assertThat("стоимость запроса несуществующего условия", unitsBefore - unitsAfter, equalTo(GET_COST));
    }

    @Test
    @Description("Общая ошибка при получении условия")
    public void generalErrorOnGetWebpageTest() {
        api.as(singleClient);
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(singleClient);
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new WebpagesSelectionCriteriaMap()
                                .withIds(singleCliebtWebpageID1)),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        StringUtils.capitalize(GetRequestMap.FIELD_NAMES)));
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(singleClient);

        assertThat("стоимость общей ошибки при получении условия", unitsBefore - unitsAfter, equalTo(GENERAL_FAULT_COST));
    }

    @Test
    @Description("Недостаточное колличество баллов при получении условия")
    public void notEnoughUnitsOnGetWebpageTest() {
        api.as(singleClient);
        log.info("Обнулим колличество доступных пользователю баллов");
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(singleClient);
        api.userSteps.clientFakeSteps().fakeWithdrawClientUnits(singleClient, unitsBefore);
        unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(singleClient);
        assumeThat("доступные баллы пользователя", unitsBefore, equalTo(0));

        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new WebpagesSelectionCriteriaMap()
                                .withIds(singleCliebtWebpageID1)).withFieldNames(WebpageFieldEnum.ID),
                new Api5Error(152, Api5ErrorDetails.NOT_ENOUGH_UNITS_FOR_OPERATION));
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(singleClient);
        assertThat("доступные баллы пользователя после ошибки", unitsAfter, equalTo(0));
    }

    @Test
    @Description("Получение агентством нескольких условий")
    public void addWebpagesUnitsCostByAgencyTest() {
        api.as(agency);
        agencyCid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign(subclient);
        agencyPid = api.as(agency).userSteps.adGroupsSteps().addDefaultGroupDynamic(agencyCid, subclient);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agency);

        agencyWebpageID1 = api.userSteps.dynamicTextAdTargetsSteps().addWebpage(
                new WebpageAddItemMap()
                        .withAdGroupId(agencyPid)
                        .withName("Name")
                        .withConditions(
                                new WebpageConditionMap()
                                        .withArguments("картоха")
                                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                                        .withOperand(WebpageConditionOperandEnum.PAGE_CONTENT)
                        )
                        .withBid(30000000l),
                subclient
        );
        agencyWebpageID2 = api.userSteps.dynamicTextAdTargetsSteps().addWebpage(
                new WebpageAddItemMap()
                        .withAdGroupId(agencyPid)
                        .withName("Name")
                        .withConditions(
                                new WebpageConditionMap()
                                        .withArguments("картоха")
                                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                                        .withOperand(WebpageConditionOperandEnum.PAGE_TITLE)
                        )
                        .withBid(30000000l),
                subclient
        );

        int agencyUnitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(agency);
        int scUnitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(subclient);
        api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new WebpagesSelectionCriteriaMap()
                                .withIds(agencyWebpageID1, agencyWebpageID2))
                        .withFieldNames(WebpageFieldEnum.ID),
                subclient);
        int scUnitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(subclient);
        int agencyUnitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(agency);

        assertThat("списание баллов у агентства", agencyUnitsBefore - agencyUnitsAfter, equalTo(0));
        assertThat("списание баллов у субклиента", scUnitsBefore - scUnitsAfter, equalTo(GET_COST + 2 * ITEM_COST_ON_GET));
    }
}
