package ru.yandex.autotests.directapi.dynamictextadtargets.get;

import java.util.Arrays;

import com.yandex.direct.api.v5.dynamictextadtargets.GetResponse;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageFieldEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageGetItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpagesSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by gerdler on 26.08.16.
 * https://st.yandex-team.ru/TESTIRT-10036
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-55156")
@Features(DynamicTextAdTargetsFeatures.GET)
@Description("Проверка выборки условий нацеливания только из динамической группы без фида")
public class GetWithDynamicTextAndDynamicTextFeedAdGroups {
    private static final String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT_GET;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignId;
    private static Long dynamicTextAdGroupId;
    private static Long dynamicTextFeedAdGroupId;
    private static Long webpageId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        dynamicTextAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        webpageId = api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(dynamicTextAdGroupId);
        dynamicTextFeedAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(dynamicTextFeedAdGroupId);
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        Long feedId = jooqDbSteps.feedsSteps().createDefaultFeed(User.get(LOGIN).getClientID());
        jooqDbSteps.adGroupsSteps().convertAdgroupDynamicToDynamicByFeed(dynamicTextFeedAdGroupId, feedId);
    }

    @Test
    public void getWebpagesByCampaignId() {
        GetResponse getResponse = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(new GetRequestMap().withSelectionCriteria(
                new WebpagesSelectionCriteriaMap()
                        .withCampaignIds(campaignId))
                .withFieldNames(WebpageFieldEnum.ID));
        assertThat("получили одно условие показа", getResponse.getWebpages(),
                beanDifferV5(Arrays.asList(new WebpageGetItemMap().withId(webpageId).getBean())));
    }

}
