package ru.yandex.autotests.directapi.dynamictextadtargets.get;

import java.math.BigDecimal;
import java.util.Collections;

import com.yandex.direct.api.v5.dynamictextadtargets.GetResponse;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageFieldEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageGetItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpagesSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(DynamicTextAdTargetsFeatures.GET)
@Description("Проверка чтения нулевых ставок")
@Issue("https://st.yandex-team.ru/DIRECT-78214")
public class GetZeroPricesTest {
    private static final String CLIENT = DynamicTextAdTargetsLogins.SINGLE_CLIENT_GET;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.SUPER_LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private Long id;

    @Before
    public void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        api.userSteps.clientFakeSteps().enableAPI(CLIENT);

        Long campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign(CLIENT);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId, CLIENT);
        id = api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(adGroupId, CLIENT);
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT).bidsSteps()
                .setBidsDynamicPrice(id, BigDecimal.ZERO);
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT).bidsSteps()
                .setBidsDynamicPriceContext(id, BigDecimal.ZERO);
    }

    @Test
    public void getWithZeroPrices() {
        Long minBid = MoneyCurrency.get(Currency.RUB).getMinPrice().bidLong().longValue();
        GetResponse getResponse = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new WebpagesSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withFieldNames(
                                WebpageFieldEnum.BID,
                                WebpageFieldEnum.CONTEXT_BID
                        ),
                CLIENT
        );
        assertThat("вернулись корректные значения ставок",
                getResponse.getWebpages(),
                beanDifferV5(
                        Collections
                                .singletonList(new WebpageGetItemMap()
                                        .withBid(minBid)
                                        .withContextBid(minBid).getBean()))
        );
    }
}
