package ru.yandex.autotests.directapi.dynamictextadtargets.resume;

import java.util.Arrays;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.ResumeRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageGetItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static com.sun.xml.ws.util.StringUtils.capitalize;

/**
 * Created by ginger on 02.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.DELETE)
@Description("Попытка запустить условия нацеливания с невалидным Id")
@RunWith(Parameterized.class)
public class ResumeInvalidIdsTest {
    private static String client = DynamicTextAdTargetsLogins.SINGLE_CLIENT_RESUME;
    private static Long cid;
    private static Long pid;
    private static long nonExistWebpageId;
    private static Long deletedCid;
    private static Long deletedPid;
    private static Long archivedCid;
    private static Long archivedPid;
    private static long holodilnikGroupId;
    private static int shard;
    private static Long webpageIdOfPid;
    private static Long deletedWebpageId;
    private static Long archivedWebpageId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public Long[] ids;

    @Parameterized.Parameter(2)
    public JavaOrPerlExpectedResult[] expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Iterable<Object[]> data() {
        prepareData();
        return Arrays.asList(new Object[][]{{"Нулевой Id", new Long[]{0L}, new JavaOrPerlExpectedResult[]{
                JavaOrPerlExpectedResult.both(ExpectedResult
                        .errors(new Notification(5005, Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER,
                                capitalize(WebpageGetItemMap.ID))))}}, {"Отрицательный Id", new Long[]{-1L},
                new JavaOrPerlExpectedResult[]{JavaOrPerlExpectedResult.both(ExpectedResult
                        .errors(new Notification(5005, Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER,
                                capitalize(WebpageGetItemMap.ID))))}},
                {"Несуществующий Id", new Long[]{nonExistWebpageId}, new JavaOrPerlExpectedResult[]{
                        JavaOrPerlExpectedResult.both(
                                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.WEBPAGE_NOT_FOUND)))}},
                {"Удаленный Id", new Long[]{deletedWebpageId}, new JavaOrPerlExpectedResult[]{
                        JavaOrPerlExpectedResult.both(
                                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.WEBPAGE_NOT_FOUND)))}},
                {"Чужой Id", new Long[]{holodilnikGroupId}, new JavaOrPerlExpectedResult[]{
                        JavaOrPerlExpectedResult.both(
                                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.WEBPAGE_NOT_FOUND)))}},
                {"Id из архивной кампании", new Long[]{archivedWebpageId}, new JavaOrPerlExpectedResult[]{
                        JavaOrPerlExpectedResult.java(ExpectedResult
                                .errors(new Notification(8300, Api5ErrorDetails.CAMPAIGN_ARCHIVED)
                                        .withDetails("Кампания помещена в архив"))).perl(
                                // Разделение на две ошибки нужно убрать, когда приедут переводы DIRECT-93168
                                ExpectedResult.errors(new Notification(8300, Api5ErrorDetails.CAMPAIGN_ARCHIVED)))}}});
    }

    private static void prepareData() {
        shard = api.userSteps.clientFakeSteps().getUserShard(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        api.as(client);

        cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        webpageIdOfPid = api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);

        nonExistWebpageId = webpageIdOfPid + 10000l;

        deletedCid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        deletedPid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(deletedCid);
        deletedWebpageId = api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(deletedPid);
        api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsDelete(deletedWebpageId);

        archivedCid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        archivedPid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(archivedCid);
        archivedWebpageId = api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(archivedPid);
        api.userSteps.campaignSteps().campaignsSuspend(archivedCid);
        api.userSteps.campaignSteps().campaignsArchive(archivedCid);

        holodilnikGroupId = 350l;
    }

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    public void tryResumeWebpagesWithInvalidId() {
        api.as(client).userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnResume(
                new ResumeRequestMap()
                        .withSelectionCriteria(
                                new IdsCriteriaMap()
                                        .withIds(ids)),
                expectedResult
        );
    }
}
