package ru.yandex.autotests.directapi.dynamictextadtargets.resume;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.ResumeRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by ginger on 10.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.RESUME)
@Description("Проверка обязательных полей в методе Webpages.Resume")
public class ResumeMandatoryFieldsTest {
    private static final String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT_RESUME;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Запрос без поля SelectionCriteria в запросе на включение условий нацеливания")
    public void requestWithoutSelectionCriteria() {
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsResume(
                new ResumeRequestMap()
                        .withSelectionCriteria(null),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(ResumeRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    @Description("Запрос без поля SelectionCriteria.Ids в запросе на включение условия нацеливания")
    public void requestWithoutIds() {
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsResume(
                new ResumeRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(IdsCriteriaMap.IDS)));
    }
}
