package ru.yandex.autotests.directapi.dynamictextadtargets.resume;

import com.yandex.direct.api.v5.dynamictextadtargets.AddResponse;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.ResumeRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 11.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.RESUME)
@Description("Включение условия нацеливания, которое уже включено")
public class ResumeResumedWebpageTest {
    private static final String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT_RESUME;
    private static Long pid;
    private static AddResponse response;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        api.as(LOGIN);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void addWebpageToClient() {
        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign(LOGIN);
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        response =  api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(new WebpageAddItemMap()
                                .withAdGroupId(pid)
                                .withName("Name")
                                .withBid(30000000l)
                        ),
                ExpectedResult.success()
        );
        assumeThat("создалась динамическая группа с 1 Webpages", response.getAddResults(), hasSize(1));
    }

    @Test
    @Description("Попытка включить уже включенное условие нацеливания должно приводить к ошибке")
    public void resumeResumedWebpage() {
        JavaOrPerlExpectedResult bothWarning = JavaOrPerlExpectedResult
                .java(ExpectedResult.warnings(new Notification(10243, Api5ErrorDetails.WEBPAGE_NOT_SUSPENDED)
                        .withMessage("Условие нацеливания не остановлено")
                        .withDetails("Условие не остановлено")))
                .perl(ExpectedResult.warnings(new Notification(10243, Api5ErrorDetails.WEBPAGE_NOT_SUSPENDED)));
        // Разделение на две ошибки нужно убрать, когда приедут переводы в DIRECT-93168

        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnResume(
                new ResumeRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(response.getAddResults().get(0).getId())),
                bothWarning);
    }
}
