package ru.yandex.autotests.directapi.dynamictextadtargets.resume;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.dynamictextadtargets.StringConditionOperatorEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageConditionOperandEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.ResumeRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageConditionMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 10.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.RESUME)
@Description("Включение условия нацеливания от имени разных ролей")
@RunWith(Parameterized.class)
public class ResumeRolesTest {

    private static final String CLIENT = DynamicTextAdTargetsLogins.SINGLE_CLIENT;
    private static final String CLIENT_REP = DynamicTextAdTargetsLogins.SINGLE_CLIENT_REP;
    private static final String AGENCY = DynamicTextAdTargetsLogins.AGENCY;
    private static final String AGENCY_REP = DynamicTextAdTargetsLogins.AGENCY_REP;
    private static final String SUBCLIENT = DynamicTextAdTargetsLogins.SUBCLIENT;
    private static final String MANAGER = Logins.MANAGER_DEFAULT;
    private static final String SERV_CLIENT = DynamicTextAdTargetsLogins.SERV_CLIENT;
    private static final String SUPER = Logins.SUPER_LOGIN;
    private static final String SUPER_READER = Logins.SUPER_READER;
    private static final String PLACER = Logins.PLACER;
    private static final String SUPPORT = Logins.SUPPORT;
    private static final String MEDIA = Logins.MEDIA;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static int shard;
    private static Long cid;
    private Long webpageID;
    private Long pid;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String loginToCreateCampaign;

    @Parameterized.Parameter(2)
    public String apiUserLogin;

    @Parameterized.Parameter(3)
    public String login;

    @Parameterized.Parameter(4)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {

        return Arrays.asList(new Object[][]{
                {"Включение условий от имени менеджера", MANAGER, MANAGER, SERV_CLIENT,
                        ExpectedResult.success()},

                {"Включение условий от имени вешальщика", SUPER, PLACER, CLIENT,
                        ExpectedResult.success()},

                {"Включение условий от имени саппорта", SUPER, SUPPORT, CLIENT,
                        ExpectedResult.success()},

                {"Включение условий от имени супера", SUPER, SUPER, CLIENT,
                        ExpectedResult.success()},

                {"Включение условий от имени медиапланера", SUPER, MEDIA, CLIENT,
                        ExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE))},

                {"Включение условий от имени суперридера", SUPER, SUPER_READER, CLIENT,
                        ExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE))},

                {"Включение условий от имени клиента для самого себя", SUPER, CLIENT, CLIENT,
                        ExpectedResult.success()},

                {"Включение условий от имени представителя клиента для клиента", SUPER, CLIENT_REP, CLIENT,
                        ExpectedResult.success()},

                {"Включение условий от имени агенства для субклиента", AGENCY, AGENCY, SUBCLIENT,
                        ExpectedResult.success()},

                {"Включение условий от имени представителя агенства для субклиента", AGENCY_REP, AGENCY_REP, SUBCLIENT,
                        ExpectedResult.success()},

                {"Включение условий от имени субклиента для самого себя", AGENCY, SUBCLIENT, SUBCLIENT,
                        ExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE))}
        });
    }

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT_REP);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AGENCY);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AGENCY_REP);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SUBCLIENT);
        api.as(loginToCreateCampaign);
        shard = api.userSteps.clientFakeSteps().getUserShard(login);

        cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign(login);
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid, login);
        webpageID = api.userSteps.dynamicTextAdTargetsSteps().addWebpage(
                new WebpageAddItemMap()
                        .withAdGroupId(pid)
                        .withName("Name")
                        .withConditions(
                                new WebpageConditionMap()
                                        .withArguments("картоха")
                                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                                        .withOperand(WebpageConditionOperandEnum.PAGE_CONTENT)
                        )
                        .withBid(30000000l),
                login
        );
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bidsDynamicSteps().setSuspended(pid, webpageID);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(apiUserLogin);
    }

    @Test
    public void resumeWebpageUsingLogin() {
        api.as(apiUserLogin);
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOn(
                Action.RESUME,
                login,
                new ResumeRequestMap().withSelectionCriteria(
                        new IdsCriteriaMap()
                                .withIds(webpageID)),
                expectedResult
        );
    }
}
