package ru.yandex.autotests.directapi.dynamictextadtargets.resume;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupsDynamicStatusblgenerated;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupsDynamicRecord;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.ResumeRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SuspendRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by buhter on 17.12.15.
 * https://st.yandex-team.ru/TESTIRT-7965
 */
@Aqua.Test
@Features(DynamicTextAdTargetsFeatures.RESUME)
@Issue("https://st.yandex-team.ru/DIRECT-49484")
public class ResumeStatusBlGeneratedTest {
    private static String client = DynamicTextAdTargetsLogins.SINGLE_CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    private static int shard;
    private Long cid;
    private Long pid;
    private Long wid;

    @Rule
    public Trashman trashman = new Trashman(api);


    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        shard = api.userSteps.clientFakeSteps().getUserShard(client);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        wid = api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid, client);
        api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsSuspend(
                new SuspendRequestMap()
                        .withSelectionCriteria(
                                new IdsCriteriaMap()
                                        .withIds(wid)
                        )
        );
    }

    @Test
    @Description("В активной группе статус должен обновиться с No в Processing")
    public void testStatusBlGeneratedAfterResumeWebpageInActiveGroupFromNo() {
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps().setAdgroupsDynamicStatusBlGenerated(pid,
                AdgroupsDynamicStatusblgenerated.No);

        api.userSteps.campaignFakeSteps().makeCampaignActive(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnResume(
                new ResumeRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(wid))
                , ExpectedResult.success()
        );
        AdgroupsDynamicRecord adgroupsDynamicRecord =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).adgroupsDynamicSteps().getAdgroupsDynamic(pid);
        assertThat("statusBlGenerated обновился"
                , adgroupsDynamicRecord.getStatusblgenerated(), equalTo(AdgroupsDynamicStatusblgenerated.Processing));
    }

    @Test
    @Description("В активной группе статус не должен обновиться с Yes в Processing")
    public void testStatusBlGeneratedAfterResumeWebpageInActiveGroupFromYes() {
        AdgroupsDynamicStatusblgenerated statusBefore = AdgroupsDynamicStatusblgenerated.Yes;

        api.userSteps.getDirectJooqDbSteps().useShard(shard).adgroupsDynamicSteps().setStatusBlGenerated(pid,
                statusBefore);

        api.userSteps.campaignFakeSteps().makeCampaignActive(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnResume(
                new ResumeRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(wid))
                , ExpectedResult.success()
        );
        AdgroupsDynamicRecord adgroupsDynamicRecord =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).adgroupsDynamicSteps().getAdgroupsDynamic(pid);
        assertThat("statusBlGenerated не обновился"
                , adgroupsDynamicRecord.getStatusblgenerated(), equalTo(statusBefore));
    }

    @Test
    @Description("В группе черновике статус не должен обновиться с No в Processing")
    public void testStatusBlGeneratedAfterResumeWebpageInDraftGroupFromNo() {
        AdgroupsDynamicStatusblgenerated statusBefore = AdgroupsDynamicStatusblgenerated.No;

        api.userSteps.getDirectJooqDbSteps().useShard(shard).adgroupsDynamicSteps().setStatusBlGenerated(pid,
                statusBefore);

        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnResume(
                new ResumeRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(wid))
                , ExpectedResult.success()
        );
        AdgroupsDynamicRecord adgroupsDynamicRecord =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).adgroupsDynamicSteps().getAdgroupsDynamic(pid);
        assertThat("statusBlGenerated не обновился"
                , adgroupsDynamicRecord.getStatusblgenerated(), equalTo(statusBefore));
    }

    @Test
    @Description("В группе черновике статус не должен обновиться с YES в Processing")
    public void testStatusBlGeneratedAfterResumeWebpageInDraftGroupFromYes() {
        AdgroupsDynamicStatusblgenerated statusBefore = AdgroupsDynamicStatusblgenerated.Yes;

        api.userSteps.getDirectJooqDbSteps().useShard(shard).adgroupsDynamicSteps().setStatusBlGenerated(pid,
                statusBefore);

        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnResume(
                new ResumeRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(wid))
                , ExpectedResult.success()
        );
        AdgroupsDynamicRecord adgroupsDynamicRecord =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).adgroupsDynamicSteps().getAdgroupsDynamic(pid);
        assertThat("statusBlGenerated не обновился"
                , adgroupsDynamicRecord.getStatusblgenerated(), equalTo(statusBefore));
    }
}
