package ru.yandex.autotests.directapi.dynamictextadtargets.resume;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.dynamictextadtargets.AddResponse;
import com.yandex.direct.api.v5.dynamictextadtargets.StringConditionOperatorEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageConditionOperandEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageFieldEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageGetItem;
import com.yandex.direct.api.v5.general.StateEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.ResumeRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageConditionMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageGetItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpagesSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static ch.lambdaj.Lambda.sort;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.everyItem;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by ginger on 10.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.RESUME)
@Description("Проверка логики метода Webpages.Resume")
public class ResumeTest {
    private static final String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT_RESUME;
    private static Long cid;
    private Long firstWebpage;
    private Long secondWebpage;
    private static int shard;
    private static Long pid;
    private static AddResponse response;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        cid = api.as(LOGIN).userSteps.campaignSteps().addDefaultDynamicTextCampaign();
    }

    @Before
    public void createWebpages(){
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        response =  api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(new WebpageAddItemMap()
                                .withAdGroupId(pid)
                                .withName("Name")
                                .withConditions(new WebpageConditionMap()
                                        .withOperand(WebpageConditionOperandEnum.PAGE_TITLE)
                                        .withOperator(StringConditionOperatorEnum.NOT_CONTAINS_ALL)
                                        .withArguments("ginger")
                                )
                                .withBid(30000000l),
                                new WebpageAddItemMap()
                                        .withAdGroupId(pid)
                                        .withName("Name2")
                                        .withConditions(new WebpageConditionMap()
                                                .withOperand(WebpageConditionOperandEnum.PAGE_CONTENT)
                                                .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                                                .withArguments("ginger")
                                        )
                                        .withBid(30000000l)
                        ),
                ExpectedResult.success(),
                ExpectedResult.success()
        );
        assumeThat("создалась динамическая группа с 1 Webpages", response.getAddResults(), hasSize(2));
        firstWebpage = response.getAddResults().get(0).getId();
        secondWebpage = response.getAddResults().get(1).getId();

        api.userSteps.getDirectJooqDbSteps().useShard(shard).bidsDynamicSteps().setSuspended(pid, firstWebpage);
        api.userSteps.getDirectJooqDbSteps().bidsDynamicSteps().setSuspended(pid, secondWebpage);
    }

    @Test
    @Issue("DIRECT-48847")
    @Description("Включить одно условие нацеливания")
    public void resumeOneWebpage() {
        api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsResume(
                new ResumeRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(
                        firstWebpage
                ))
        );
        List<WebpageGetItem> webpages = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(new WebpagesSelectionCriteriaMap()
                        .withIds(firstWebpage, secondWebpage)).withFieldNames(WebpageFieldEnum.STATE, WebpageFieldEnum.ID)).getWebpages();
        webpages = sort(webpages, on(WebpageGetItem.class).getId());

        assumeThat("было включено верное условие", webpages, beanEquivalent(Arrays.asList(
                (WebpageGetItem) new WebpageGetItemMap()
                        .withId(firstWebpage)
                        .withState(StateEnum.ON).getBean(),
                (WebpageGetItem) new WebpageGetItemMap()
                        .withId(secondWebpage)
                        .withState(StateEnum.SUSPENDED).getBean())));
    }

    @Test
    @Issue("DIRECT-48847")
    @Description("Включить два условия нацеливания")
    public void resumeTwoWebpages() {
        api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsResume(
                new ResumeRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(
                        firstWebpage, secondWebpage
                ))
        );

        List<WebpageGetItem> webpages = api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsGet(
                new GetRequestMap().withSelectionCriteria(new WebpagesSelectionCriteriaMap()
                        .withIds(firstWebpage, secondWebpage)).withFieldNames(WebpageFieldEnum.STATE, WebpageFieldEnum.ID)).getWebpages();
        List<StateEnum> states = extract(webpages, on(WebpageGetItem.class).getState());
        assertThat("оба условия включены", states, everyItem(equalTo(StateEnum.ON)));
    }
}
