package ru.yandex.autotests.directapi.dynamictextadtargets.setbids;

import com.yandex.direct.api.v5.general.PriorityEnum;
import org.joda.time.DateTime;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.GroupFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SetBidsItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SetBidsRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageConditionMap;
import ru.yandex.autotests.directapi.model.api5.general.SetBidsExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by pavryabov on 11.09.16.
 * https://st.yandex-team.ru/TESTIRT-10231
 */
@Aqua.Test
@Features(DynamicTextAdTargetsFeatures.SET_BIDS)
@Description("Проверка изменения статусов группы и условия нацеливания после изменения StrategyPriority")
public class ChangeStrategyPriorityAndCheckStatusesTest {

    private static final String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT;
    private static Long id;
    private static Long pid;
    private static String lastChange;
    private static int shard;
    private static GroupFakeInfo groupFakeInfo;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void addUnitsToClient() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaignWithStrategies(
                new DynamicTextCampaignSearchStrategyAddMap().defaultWbMaximumClicks(Currency.RUB),
                new DynamicTextCampaignNetworkStrategyAddMap().defaultServingOff()
        );
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        id = api.userSteps.dynamicTextAdTargetsSteps().addWebpage(new WebpageAddItemMap()
                .withAdGroupId(pid)
                .withStrategyPriority(PriorityEnum.NORMAL)
                .withName("Name")
                .withConditions(new WebpageConditionMap().defaultWebpage()));

        lastChange = DateTime.now().minusMinutes(5).toString("yyyy-MM-dd hh:mm:ss");
        groupFakeInfo = api.userSteps.groupFakeSteps().getGroupParams(pid);
        groupFakeInfo.setLastChange(lastChange);
        groupFakeInfo.setStatusBsSynced(Status.YES);
        api.userSteps.groupFakeSteps().updateGroupParams(groupFakeInfo);
        GroupFakeInfo actualGroupFakeInfo = api.userSteps.groupFakeSteps().getGroupParams(pid);
        assumeThat("группе установились ожидаемые параметры", actualGroupFakeInfo, beanDiffer(groupFakeInfo));

        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnSetBids(new SetBidsRequestMap()
                        .withBids(new SetBidsItemMap()
                                .withId(id)
                                .withStrategyPriority(PriorityEnum.HIGH)),
                SetBidsExpectedResult.successWithId());
    }

    @Test
    public void checkAdGroups() {
        GroupFakeInfo actualGroupFakeInfo = api.userSteps.groupFakeSteps().getGroupParams(pid);
        assumeThat("параметры группы не обновились", actualGroupFakeInfo, beanDiffer(groupFakeInfo));
    }
}
