package ru.yandex.autotests.directapi.dynamictextadtargets.setbids;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SetBidsItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SetBidsRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.general.SetBidsExpectedResult;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static com.sun.xml.ws.util.StringUtils.capitalize;

/**
 * Created by semkagtn on 26.11.15.
 * https://st.yandex-team.ru/TESTIRT-7700
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.SET_BIDS)
@Description("Установка значения Bid для webpages для кампаний с разными стратегиями")
@RunWith(Parameterized.class)
public class SetBidsBidStrategiesTest {

    private static final String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT;
    private static final Integer GOAL_ID = MetrikaGoals.getRandom();

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public DynamicTextCampaignSearchStrategyTypeEnum searchStrategyName;

    @Parameterized.Parameter(1)
    public DynamicTextCampaignSearchStrategyMap searchStrategy;

    @Parameterized.Parameter(2)
    public SetBidsExpectedResult expectedResult;

    @Parameterized.Parameters(name = "Стратегия на поиске = {0}")
    public static Collection data() {
        return Arrays.asList((Object[][]) new Object[][]{
                {DynamicTextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION,
                        new DynamicTextCampaignSearchStrategyMap().defaultHighestPosition(),
                        SetBidsExpectedResult.successWithId()},

                {DynamicTextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS,
                        new DynamicTextCampaignSearchStrategyMap().defaultWbMaximumClicks(Currency.RUB),
                        SetBidsExpectedResult.warningsWithID(
                                new Notification(10160, Api5ErrorDetails.BID_WILL_NOT_APPLIED_BECAUSE_OF_AUTO_STRATEGY,
                                        capitalize(SetBidsItemMap.BID)))},

                {DynamicTextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CONVERSION_RATE,
                        new DynamicTextCampaignSearchStrategyMap().defaultWbMaximumConversionRate(Currency.RUB, 0L),
                        SetBidsExpectedResult.warningsWithID(
                                new Notification(10160, Api5ErrorDetails.BID_WILL_NOT_APPLIED_BECAUSE_OF_AUTO_STRATEGY,
                                        capitalize(SetBidsItemMap.BID)))},

                {DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_CPC,
                        new DynamicTextCampaignSearchStrategyMap().defaultAverageCpc(Currency.RUB),
                        SetBidsExpectedResult.warningsWithID(
                                new Notification(10160, Api5ErrorDetails.BID_WILL_NOT_APPLIED_BECAUSE_OF_AUTO_STRATEGY,
                                        capitalize(SetBidsItemMap.BID)))},

                {DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_CPA,
                        new DynamicTextCampaignSearchStrategyMap().defaultAverageCpa(Currency.RUB, 0L),
                        SetBidsExpectedResult.warningsWithID(
                                new Notification(10160, Api5ErrorDetails.BID_WILL_NOT_APPLIED_BECAUSE_OF_AUTO_STRATEGY,
                                        capitalize(SetBidsItemMap.BID)))},

                {DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_ROI,
                        new DynamicTextCampaignSearchStrategyMap().defaultAverageRoi(0L),
                        SetBidsExpectedResult.warningsWithID(
                                new Notification(10160, Api5ErrorDetails.BID_WILL_NOT_APPLIED_BECAUSE_OF_AUTO_STRATEGY,
                                        capitalize(SetBidsItemMap.BID)))},

        });
    }

    private Long webpageId;

    @Before
    @Step("Подготовка данных для теста")
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign(LOGIN);
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().addCampMetrikaGoals(cid, GOAL_ID.longValue(), 100L, 100L);
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                .withId(cid)
                .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap()
                        .withBiddingStrategy(new DynamicTextCampaignStrategyMap()
                                .withSearch(searchStrategy)
                                .withNetwork(new DynamicTextCampaignNetworkStrategyMap().defaultServingOff())))),
                ExpectedResult.success());
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        webpageId = api.userSteps.dynamicTextAdTargetsSteps().addWebpage(new WebpageAddItemMap()
                .defaultWebpage(adGroupId));
    }

    @Test
    public void setBids() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnSetBids(new SetBidsRequestMap()
                        .withBids(new SetBidsItemMap()
                                .withId(webpageId)
                                .withBid(50_000_000L)),
                expectedResult);
    }
}
