package ru.yandex.autotests.directapi.dynamictextadtargets.setbids;

import java.util.Arrays;

import com.yandex.direct.api.v5.dynamictextadtargets.StringConditionOperatorEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageConditionOperandEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SetBidsItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SetBidsRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageConditionMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlSetBidsExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.general.SetBidsExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(DynamicTextAdTargetsFeatures.SET_BIDS)
@Description("Установка bids по adGroupId в группе с удаленными условиями")
@RunWith(Parameterized.class)
public class SetBidsByAdGroupIdWithDeletedWebpagesTest {

    private static final String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public Long adGroupId;

    @Parameterized.Parameter(2)
    public JavaOrPerlSetBidsExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Iterable<Object[]> data() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        Long anotherAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);

        // adGroup

        Long deletedWebpageId = api.userSteps.dynamicTextAdTargetsSteps().addWebpage(new WebpageAddItemMap()
                .withAdGroupId(adGroupId)
                .withName("Name2")
                .withConditions(new WebpageConditionMap()
                        .withOperand(WebpageConditionOperandEnum.PAGE_TITLE)
                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                        .withArguments("arg2"))
                .withBid(25_000_000L));


        api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsDelete(new DeleteRequestMap()
                .withSelectionCriteria(new IdsCriteriaMap().withIds(deletedWebpageId)));

        // anotherAdGroup

        api.userSteps.dynamicTextAdTargetsSteps().addWebpage(new WebpageAddItemMap()
                .withAdGroupId(anotherAdGroupId)
                .withName("Name1")
                .withConditions(new WebpageConditionMap()
                        .withOperand(WebpageConditionOperandEnum.PAGE_TITLE)
                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                        .withArguments("arg1"))
                .withBid(15_000_000L));

        deletedWebpageId = api.userSteps.dynamicTextAdTargetsSteps().addWebpage(new WebpageAddItemMap()
                .withAdGroupId(anotherAdGroupId)
                .withName("Name2")
                .withConditions(new WebpageConditionMap()
                        .withOperand(WebpageConditionOperandEnum.PAGE_TITLE)
                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                        .withArguments("arg2"))
                .withBid(25_000_000L));


        api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsDelete(new DeleteRequestMap()
                .withSelectionCriteria(new IdsCriteriaMap().withIds(deletedWebpageId)));

        return Arrays.asList(new Object[][]{
                {"Группа в которой один удаленный Webpage", adGroupId,
                        JavaOrPerlSetBidsExpectedResult
                                .java(SetBidsExpectedResult
                                        .errors(new Notification(8800, Api5ErrorDetails.TARGETS_FOR_GROUP_NOT_FOUND,
                                                adGroupId)
                                                .withDetails("Условия для группы объявлений " + adGroupId.toString() + " не найдены")
                                        ))
                                .perl(
                                SetBidsExpectedResult
                                        .errors(new Notification(8800, Api5ErrorDetails.TARGETS_FOR_GROUP_NOT_FOUND,
                                                adGroupId)
                                        ))},
                {"Группа в который один удаленный и один неудаленный Webpage", anotherAdGroupId,
                        JavaOrPerlSetBidsExpectedResult
                                .java(SetBidsExpectedResult.successWithAdGroupId())
                                .perl(SetBidsExpectedResult.successWithAdGroupId())}
        });
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void requestWithInvalidId() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnSetBids(new SetBidsRequestMap()
                        .withBids(new SetBidsItemMap()
                                .withBid(20_000_000L)
                                .withAdGroupId(adGroupId)),
                expectedResult);
    }
}
