package ru.yandex.autotests.directapi.dynamictextadtargets.setbids;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignNetworkStrategyTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SetBidsItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SetBidsRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.general.SetBidsExpectedResult;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static com.sun.xml.ws.util.StringUtils.capitalize;

/**
 * Created by semkagtn on 27.11.15.
 * https://st.yandex-team.ru/TESTIRT-7700
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.SET_BIDS)
@Description("Установка значения ContextBid для webpages для кампаний с разными стратегиями")
@RunWith(Parameterized.class)
public class SetBidsContextBidStrategiesTest {

    private static final String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT;
    private static final Integer GOAL_ID = MetrikaGoals.getRandom();

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public DynamicTextCampaignNetworkStrategyTypeEnum contextStrategyName;

    @Parameterized.Parameter(1)
    public DynamicTextCampaignNetworkStrategyMap contextStrategy;

    @Parameterized.Parameter(2)
    public SetBidsExpectedResult expectedResult;

    @Parameterized.Parameters(name = "Стратегия на РСЯ = {0}")
    public static Collection data() {
        return Arrays.asList(new Object[][]{
                {DynamicTextCampaignNetworkStrategyTypeEnum.SERVING_OFF,
                        new DynamicTextCampaignNetworkStrategyMap().defaultServingOff(),
                        SetBidsExpectedResult.warningsWithID(
                                new Notification(10160, Api5ErrorDetails.BID_WILL_NOT_APPLIED_BECAUSE_OF_SHOWS_DISABLED_ON_CONTEXT,
                                        capitalize(SetBidsItemMap.CONTEXT_BID)))},
        });
    }

    private Long webpageId;

    @Before
    @Step("Подготовка данных для теста")
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign(LOGIN);
        //api.userSteps.campaignStepsV4().linkMetrikaGoal(cid, GOAL_ID, 100, 100);
        api.userSteps.campaignSteps().campaignsUpdate(new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                .withId(cid)
                .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap()
                        .withBiddingStrategy(new DynamicTextCampaignStrategyMap()
                                .withSearch(new DynamicTextCampaignSearchStrategyMap().defaultHighestPosition())
                                .withNetwork(contextStrategy)))));
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        webpageId = api.userSteps.dynamicTextAdTargetsSteps().addWebpage(new WebpageAddItemMap()
                .defaultWebpage(adGroupId));
    }

    @Test
    public void setBids() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnSetBids(new SetBidsRequestMap()
                        .withBids(new SetBidsItemMap()
                                .withId(webpageId)
                                .withContextBid(50_000_000L)),
                expectedResult);
    }
}
