package ru.yandex.autotests.directapi.dynamictextadtargets.setbids;

import java.util.List;

import com.yandex.direct.api.v5.dynamictextadtargets.StringConditionOperatorEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageConditionOperandEnum;
import com.yandex.direct.api.v5.general.PriorityEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SetBidsItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SetBidsRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageConditionMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlSetBidsExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.general.SetBidsExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 24.11.15.
 * https://st.yandex-team.ru/TESTIRT-7700
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.SET_BIDS)
@Description("Проверка того, что запрос обрабатывается поэлементно")
public class SetBidsDescreteResponseTest {

    private static final String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long webpageId1;
    private static Long webpageId2;

    @BeforeClass
    public static void prepareStaticData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        Long campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        List<Long> webpageIds = api.userSteps.dynamicTextAdTargetsSteps().addWebpages(
                new WebpageAddItemMap()
                        .withAdGroupId(adGroupId)
                        .withName("Name1")
                        .withConditions(new WebpageConditionMap()
                                        .withOperand(WebpageConditionOperandEnum.PAGE_TITLE)
                                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                                        .withArguments("arg"))
                        .withBid(30_000_000L),
                new WebpageAddItemMap()
                        .withAdGroupId(adGroupId)
                        .withName("Name2")
                        .withConditions(new WebpageConditionMap()
                                        .withOperand(WebpageConditionOperandEnum.PAGE_CONTENT)
                                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                                        .withArguments("arg"))
                        .withBid(30_000_000L));
        webpageId1 = webpageIds.get(0);
        webpageId2 = webpageIds.get(1);
    }

    @Test
    @Description("Запрос, порождающий ответ с двумя ошибками")
    public void twoErrors() {
        SetBidsExpectedResult perlError =
                SetBidsExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_TARGET_NOT_FOUND));
        SetBidsExpectedResult javaError =
                SetBidsExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_TARGET_NOT_FOUND)
                        .withDetails("Условие нацеливания не найдено"));
        JavaOrPerlSetBidsExpectedResult javaAndPerlError = JavaOrPerlSetBidsExpectedResult
                .java(javaError)
                .perl(perlError);


        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnSetBids(new SetBidsRequestMap().withBids(
                        new SetBidsItemMap()
                                .withId(webpageId1 + 700_000)
                                .withBid(50_000_000L),
                        new SetBidsItemMap()
                                .withId(webpageId2 + 700_000)
                                .withBid(50_000_000L)),
                javaAndPerlError,
                javaAndPerlError);
    }

    @Test
    @Description("Запрос, порождающий ответ с двумя предупреждениями")
    public void twoWarnings() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnSetBids(new SetBidsRequestMap().withBids(
                        new SetBidsItemMap()
                                .withId(webpageId1)
                                .withStrategyPriority(PriorityEnum.HIGH),
                        new SetBidsItemMap()
                                .withId(webpageId2)
                                .withStrategyPriority(PriorityEnum.HIGH)),
                SetBidsExpectedResult.warningsWithID(
                        new Notification(10161, Api5ErrorDetails.FIELD_WILL_NOT_CHANGE_BECAUSE_OF_MANUAL_STRATEGY,
                                capitalize(SetBidsItemMap.STRATEGY_PRIORITY))),
                SetBidsExpectedResult.warningsWithID(
                        new Notification(10161, Api5ErrorDetails.FIELD_WILL_NOT_CHANGE_BECAUSE_OF_MANUAL_STRATEGY,
                                capitalize(SetBidsItemMap.STRATEGY_PRIORITY))));
    }

    @Test
    @Description("Ответ с ошибкой и с успешным результатом")
    public void oneErrorOneSuccess() {
        SetBidsExpectedResult perlError =
                SetBidsExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_TARGET_NOT_FOUND));
        SetBidsExpectedResult javaError =
                SetBidsExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_TARGET_NOT_FOUND)
                        .withDetails("Условие нацеливания не найдено"));
        JavaOrPerlSetBidsExpectedResult javaAndPerlError = JavaOrPerlSetBidsExpectedResult
                .java(javaError)
                .perl(perlError);

        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnSetBids(new SetBidsRequestMap().withBids(
                        new SetBidsItemMap()
                                .withId(webpageId1 + 700_000)
                                .withBid(50_000_000L),
                        new SetBidsItemMap()
                                .withId(webpageId2)
                                .withBid(50_000_000L)),
                javaAndPerlError,
                JavaOrPerlSetBidsExpectedResult.both(SetBidsExpectedResult.successWithId()));
    }

    @Test
    @Description("Ответ с предупреждением и с успешным результатом")
    public void oneWarningOneSuccess() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnSetBids(new SetBidsRequestMap().withBids(
                        new SetBidsItemMap()
                                .withId(webpageId1)
                                .withStrategyPriority(PriorityEnum.HIGH),
                        new SetBidsItemMap()
                                .withId(webpageId2)
                                .withBid(50_000_000L)),
                SetBidsExpectedResult.warningsWithID(
                        new Notification(10161, Api5ErrorDetails.FIELD_WILL_NOT_CHANGE_BECAUSE_OF_MANUAL_STRATEGY,
                                capitalize(SetBidsItemMap.STRATEGY_PRIORITY))),
                SetBidsExpectedResult.successWithId());
    }

    @Test
    @Description("Ответ с предупреждением и ошибкой")
    public void oneWarningOneError() {
        SetBidsExpectedResult perlError =
                SetBidsExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_TARGET_NOT_FOUND));
        SetBidsExpectedResult javaError =
                SetBidsExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_TARGET_NOT_FOUND)
                        .withDetails("Условие нацеливания не найдено"));
        JavaOrPerlSetBidsExpectedResult javaAndPerlError = JavaOrPerlSetBidsExpectedResult
                .java(javaError)
                .perl(perlError);

        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnSetBids(new SetBidsRequestMap().withBids(
                        new SetBidsItemMap()
                                .withId(webpageId1)
                                .withStrategyPriority(PriorityEnum.HIGH),
                        new SetBidsItemMap()
                                .withId(webpageId2 + 700_000L)
                                .withBid(50_000_000L)),
                JavaOrPerlSetBidsExpectedResult.both(SetBidsExpectedResult.warningsWithID(
                        new Notification(10161, Api5ErrorDetails.FIELD_WILL_NOT_CHANGE_BECAUSE_OF_MANUAL_STRATEGY,
                                capitalize(SetBidsItemMap.STRATEGY_PRIORITY)))),
                javaAndPerlError);
    }
}
