package ru.yandex.autotests.directapi.dynamictextadtargets.setbids;

import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SetBidsItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SetBidsRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlSetBidsExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.general.SetBidsExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 24.11.15.
 * https://st.yandex-team.ru/TESTIRT-7700
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.SET_BIDS)
@Description("Вызов метода для групп разных типов")
@RunWith(Parameterized.class)
public class SetBidsDifferentAdGroupTypesTest {

    private static final String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    private static DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public PhrasesAdgroupType type;

    @Parameterized.Parameters(name = "{0}")
    public static Iterable<Object[]> data() {
        return Stream.of(PhrasesAdgroupType.values())
                .filter(type -> type != PhrasesAdgroupType.dynamic)
                .map(x -> new Object[]{x})
                .collect(Collectors.toList());
    }

    private static int shard;

    @BeforeClass
    public static void getUsersShard() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    private Long adGroupId;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        jooqDbSteps.adGroupsSteps().setType(adGroupId, type);
    }

    @Test
    public void requestSetBidsForAdGroup() {
        SetBidsExpectedResult perlError =
                SetBidsExpectedResult.errors(new Notification(8800, Api5ErrorDetails.TARGETS_FOR_GROUP_NOT_FOUND,
                        adGroupId));

        SetBidsExpectedResult javaError =
                SetBidsExpectedResult.errors(new Notification(8800, Api5ErrorDetails.TARGETS_FOR_GROUP_NOT_FOUND,
                        adGroupId)
                        .withDetails("Условия для группы объявлений " + adGroupId.toString() + " не найдены"));

        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnSetBids(new SetBidsRequestMap()
                        .withBids(new SetBidsItemMap()
                                .withAdGroupId(adGroupId)
                                .withBid(20_000_000L)),
                JavaOrPerlSetBidsExpectedResult
                        .java(javaError)
                        .perl(perlError));
    }
}
