package ru.yandex.autotests.directapi.dynamictextadtargets.setbids;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SetBidsItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SetBidsRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlSetBidsExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.general.SetBidsExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by gerdler on 12.08.16.
 * https://st.yandex-team.ru/TESTIRT-10036
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-55156")
@Features(DynamicTextAdTargetsFeatures.RESUME)
@Description("Проверяем получение ошибки при попытке выставить ставку на фильтр в ДО-группе с фидом")
public class SetBidsDynamicTextFeedFilterTest {
    private static final String CLIENT = DynamicTextAdTargetsLogins.SINGLE_CLIENT_RESUME;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long dynamicCampaignId;
    private static Long dynamicTextFeedAdGroupId;
    private static Long dynamicTextFeedFilterId;
    private static Money bid;

    @BeforeClass
    public static void initTest() {
        dynamicCampaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        dynamicTextFeedAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(dynamicCampaignId);
        dynamicTextFeedFilterId = api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(dynamicTextFeedAdGroupId);
        int shard = api.userSteps.clientFakeSteps().getUserShard(CLIENT);
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        Long feedId = jooqDbSteps.feedsSteps().createDefaultFeed(User.get(CLIENT).getClientID());
        jooqDbSteps.adGroupsSteps().convertAdgroupDynamicToDynamicByFeed(dynamicTextFeedAdGroupId, feedId);
        bid = MoneyCurrency.get(Currency.RUB).getLongMinPrice();
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    public void setBidsByDynamicTextFeedFilterId() {
        SetBidsExpectedResult perlError =
                SetBidsExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_TARGET_NOT_FOUND));
        SetBidsExpectedResult javaError =
                SetBidsExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_TARGET_NOT_FOUND)
                        .withDetails("Условие нацеливания не найдено"));
        JavaOrPerlSetBidsExpectedResult javaAndPerlError = JavaOrPerlSetBidsExpectedResult
                .java(javaError)
                .perl(perlError);

        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap()
                        .withBids(new SetBidsItemMap()
                                .withId(dynamicTextFeedFilterId)
                                .withBid(bid.longValue())),
                javaAndPerlError
        );
    }

    @Test
    public void setBidsByDynamicTextFeedAdGroupId() {
        SetBidsExpectedResult perlError =
                SetBidsExpectedResult.errors(new Notification(8800, Api5ErrorDetails.TARGETS_FOR_GROUP_NOT_FOUND,
                        dynamicTextFeedAdGroupId));
        SetBidsExpectedResult javaError =
                SetBidsExpectedResult.errors(new Notification(8800, Api5ErrorDetails.TARGETS_FOR_GROUP_NOT_FOUND,
                        dynamicTextFeedAdGroupId)
                        .withDetails("Условия для группы объявлений " + dynamicTextFeedAdGroupId.toString()
                                + " не найдены"));
        JavaOrPerlSetBidsExpectedResult javaAndPerlError = JavaOrPerlSetBidsExpectedResult
                .java(javaError)
                .perl(perlError);

        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap()
                        .withBids(new SetBidsItemMap()
                                .withAdGroupId(dynamicTextFeedAdGroupId)
                                .withBid(bid.longValue())),
                javaAndPerlError
        );
    }

    @Test
    public void setBidsByDynamicCampaignId() {
        SetBidsExpectedResult perlError =
                SetBidsExpectedResult.errors(new Notification(8800, Api5ErrorDetails.TARGETS_FOR_CAMPAIGN_NOT_FOUND,
                        dynamicCampaignId));
        SetBidsExpectedResult javaError =
                SetBidsExpectedResult.errors(new Notification(8800, Api5ErrorDetails.TARGETS_FOR_CAMPAIGN_NOT_FOUND,
                        dynamicCampaignId)
                        .withDetails("Условия для кампании " + dynamicCampaignId.toString() + " не найдены"));
        JavaOrPerlSetBidsExpectedResult javaAndPerlError = JavaOrPerlSetBidsExpectedResult
                .java(javaError)
                .perl(perlError);

        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap()
                        .withBids(new SetBidsItemMap()
                                .withCampaignId(dynamicCampaignId)
                                .withBid(bid.longValue())),
                javaAndPerlError
        );
    }
}
