package ru.yandex.autotests.directapi.dynamictextadtargets.setbids;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SetBidsItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SetBidsRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlSetBidsExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.general.SetBidsExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 24.11.15.
 * https://st.yandex-team.ru/TESTIRT-7700
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.SET_BIDS)
@Description("Протеворечащие друг другу идентификаторы в запросе")
public class SetBidsIdsConflictsInRequestTest {

    private static final String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long webpageId;
    private static Long adGroupId;
    private static Long campaignId;

    @BeforeClass
    public static void prepareStaticData() {
        campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        webpageId = api.userSteps.dynamicTextAdTargetsSteps().addWebpage(new WebpageAddItemMap()
                .defaultWebpage(adGroupId));
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Id и AdGroupId в запросе")
    public void idAdGroupId() {
        SetBidsExpectedResult perlError =
                SetBidsExpectedResult.errors(new Notification(5009,
                        Api5ErrorDetails.ONLY_ONE_OF_FIELDS_SHOULD_BE_SPECIFIED_BM,
                        String.join(", ", capitalize(SetBidsItemMap.ID),
                                capitalize(SetBidsItemMap.CAMPAIGN_ID),
                                capitalize(SetBidsItemMap.AD_GROUP_ID))));
        SetBidsExpectedResult javaError =
                SetBidsExpectedResult.errors(new Notification(5009,
                        Api5ErrorDetails.ONLY_ONE_OF_FIELDS_SHOULD_BE_SPECIFIED_BM,
                        String.join(", ", capitalize(SetBidsItemMap.ID),
                                capitalize(SetBidsItemMap.AD_GROUP_ID),
                                capitalize(SetBidsItemMap.CAMPAIGN_ID))));
        JavaOrPerlSetBidsExpectedResult javaAndPerlError = JavaOrPerlSetBidsExpectedResult
                .java(javaError)
                .perl(perlError);

        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnSetBids(new SetBidsRequestMap()
                        .withBids(new SetBidsItemMap()
                                .withBid(20_000_000L)
                                .withId(webpageId)
                                .withAdGroupId(adGroupId)),
                javaAndPerlError);
    }

    @Test
    @Description("Id и CampaignId в запросе")
    public void idCampaignId() {
        SetBidsExpectedResult perlError =
                SetBidsExpectedResult.errors(new Notification(5009,
                        Api5ErrorDetails.ONLY_ONE_OF_FIELDS_SHOULD_BE_SPECIFIED_BM,
                        String.join(", ", capitalize(SetBidsItemMap.ID),
                                capitalize(SetBidsItemMap.CAMPAIGN_ID),
                                capitalize(SetBidsItemMap.AD_GROUP_ID))));
        SetBidsExpectedResult javaError =
                SetBidsExpectedResult.errors(new Notification(5009,
                        Api5ErrorDetails.ONLY_ONE_OF_FIELDS_SHOULD_BE_SPECIFIED_BM,
                        String.join(", ", capitalize(SetBidsItemMap.ID),
                                capitalize(SetBidsItemMap.AD_GROUP_ID),
                                capitalize(SetBidsItemMap.CAMPAIGN_ID))));
        JavaOrPerlSetBidsExpectedResult javaAndPerlError = JavaOrPerlSetBidsExpectedResult
                .java(javaError)
                .perl(perlError);

        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnSetBids(new SetBidsRequestMap()
                        .withBids(new SetBidsItemMap()
                                .withBid(20_000_000L)
                                .withId(webpageId)
                                .withCampaignId(campaignId)),
                javaAndPerlError);
    }

    @Test
    @Description("AdGroupId и CampaignId в запросе")
    public void adGroupIdCampaignId() {
        SetBidsExpectedResult perlError =
                SetBidsExpectedResult.errors(new Notification(5009,
                        Api5ErrorDetails.ONLY_ONE_OF_FIELDS_SHOULD_BE_SPECIFIED_BM,
                        String.join(", ", capitalize(SetBidsItemMap.ID),
                                capitalize(SetBidsItemMap.CAMPAIGN_ID),
                                capitalize(SetBidsItemMap.AD_GROUP_ID))));
        SetBidsExpectedResult javaError =
                SetBidsExpectedResult.errors(new Notification(5009,
                        Api5ErrorDetails.ONLY_ONE_OF_FIELDS_SHOULD_BE_SPECIFIED_BM,
                        String.join(", ", capitalize(SetBidsItemMap.ID),
                                capitalize(SetBidsItemMap.AD_GROUP_ID),
                                capitalize(SetBidsItemMap.CAMPAIGN_ID))));
        JavaOrPerlSetBidsExpectedResult javaAndPerlError = JavaOrPerlSetBidsExpectedResult
                .java(javaError)
                .perl(perlError);

        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnSetBids(new SetBidsRequestMap()
                        .withBids(new SetBidsItemMap()
                                .withBid(20_000_000L)
                                .withAdGroupId(adGroupId)
                                .withCampaignId(campaignId)),
                javaAndPerlError);
    }

    @Test
    @Description("Разные типы объектов в разных элементах в запросе")
    public void differentObjectsInDifferentItems() {
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsSetBids(new SetBidsRequestMap().withBids(
                        new SetBidsItemMap()
                                .withBid(20_000_000L)
                                .withAdGroupId(adGroupId),
                        new SetBidsItemMap()
                                .withBid(25_000_000L)
                                .withCampaignId(campaignId)),
                new Api5Error(4005, Api5ErrorDetails.EMPTY_STRING));
    }

    @Test
    @Description("Два одинаковых идентификатора Webpage в запросе")
    public void twoSameIdsInRequest() {
        SetBidsExpectedResult perlError =
                SetBidsExpectedResult.errors(new Notification(9800));
        SetBidsExpectedResult javaError =
                SetBidsExpectedResult.errors(new Notification(9800,
                        Api5ErrorDetailsJava.OBJECT_CANNOT_BE_MORE_THAN_ONCE_IN_REQUEST));
        JavaOrPerlSetBidsExpectedResult javaAndPerlError = JavaOrPerlSetBidsExpectedResult
                .java(javaError)
                .perl(perlError);

        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnSetBids(new SetBidsRequestMap().withBids(
                        new SetBidsItemMap()
                                .withBid(20_000_000L)
                                .withId(webpageId),
                        new SetBidsItemMap()
                                .withBid(25_000_000L)
                                .withId(webpageId)),
                javaAndPerlError,
                javaAndPerlError);
    }

    @Test
    @Description("Два одинаковых идентификатора группы в запросе")
    public void twoSameAdGroupIdsInRequest() {
        SetBidsExpectedResult perlError =
                SetBidsExpectedResult.errors(new Notification(9800));
        SetBidsExpectedResult javaError =
                SetBidsExpectedResult.errors(new Notification(9800,
                        Api5ErrorDetailsJava.OBJECT_CANNOT_BE_MORE_THAN_ONCE_IN_REQUEST));
        JavaOrPerlSetBidsExpectedResult javaAndPerlError = JavaOrPerlSetBidsExpectedResult
                .java(javaError)
                .perl(perlError);

        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnSetBids(new SetBidsRequestMap().withBids(
                        new SetBidsItemMap()
                                .withBid(20_000_000L)
                                .withAdGroupId(adGroupId),
                        new SetBidsItemMap()
                                .withBid(25_000_000L)
                                .withAdGroupId(adGroupId)),
                javaAndPerlError,
                javaAndPerlError);
    }

    @Test
    @Description("Два одинаковых идентификатора кампании в запросе")
    public void twoSameCampaignIdsInRequest() {
        SetBidsExpectedResult perlError =
                SetBidsExpectedResult.errors(new Notification(9800));
        SetBidsExpectedResult javaError =
                SetBidsExpectedResult.errors(new Notification(9800,
                        Api5ErrorDetailsJava.OBJECT_CANNOT_BE_MORE_THAN_ONCE_IN_REQUEST));
        JavaOrPerlSetBidsExpectedResult javaAndPerlError = JavaOrPerlSetBidsExpectedResult
                .java(javaError)
                .perl(perlError);

        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnSetBids(new SetBidsRequestMap().withBids(
                        new SetBidsItemMap()
                                .withBid(20_000_000L)
                                .withCampaignId(campaignId),
                        new SetBidsItemMap()
                                .withBid(25_000_000L)
                                .withCampaignId(campaignId)),
                javaAndPerlError,
                javaAndPerlError);
    }
}
