package ru.yandex.autotests.directapi.dynamictextadtargets.setbids;

import java.util.Arrays;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SetBidsItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SetBidsRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.general.SetBidsActionResultMap;
import ru.yandex.autotests.directapi.model.api5.general.SetBidsExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 23.11.15.
 * https://st.yandex-team.ru/TESTIRT-7700
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.SET_BIDS)
@Description("Невалидные значения в поле AdGroupId в запросе")
@RunWith(Parameterized.class)
public class SetBidsInvalidAdGroupIdTest {

    private static final String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public Long invalidId;

    @Parameterized.Parameter(2)
    public Notification expectedError;

    @Parameterized.Parameters(name = "{0}")
    public static Iterable<Object[]> data() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long deletedAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.adGroupsSteps().deleteGroup(deletedAdGroupId);
        Long nonexistentAdGroupId = deletedAdGroupId + 500_000L;

        return Arrays.asList(new Object[][]{
                {"Нулевой идентификатор", 0L,
                        new Notification(5005, Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER,
                                capitalize(SetBidsActionResultMap.AD_GROUP_ID))},
                {"Отрицательный идентификатор", -1L,
                        new Notification(5005, Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER,
                                capitalize(SetBidsActionResultMap.AD_GROUP_ID))},
                {"Удалённый идентификатор", deletedAdGroupId,
                        new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND)},
                {"Несуществующий идентификатор", nonexistentAdGroupId,
                        new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND)},
        });
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void requestWithInvalidId() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnSetBids(new SetBidsRequestMap()
                        .withBids(new SetBidsItemMap()
                                .withBid(20_000_000L)
                                .withAdGroupId(invalidId)),
                SetBidsExpectedResult.errors(expectedError));
    }
}
