package ru.yandex.autotests.directapi.dynamictextadtargets.setbids;

import org.json.simple.JSONObject;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SetBidsItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SetBidsRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by semkagtn on 26.11.15.
 * https://st.yandex-team.ru/TESTIRT-7700
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.SET_BIDS)
@Stories(ApiStories.JSON5)
@Description("Невалидный JSON в запросах")
public class SetBidsJsonValidationTest {

    private static final String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN).protocol(ProtocolType.JSON);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Test
    @Description("Не массив в поле Bids")
    public void notArrayInBids() {
        JSONObject bid = new JSONObject();
        bid.put(capitalize(SetBidsItemMap.BID), 10_000_000L);
        bid.put(capitalize(SetBidsItemMap.ID), 1L);

        JSONObject request = new JSONObject();
        request.put(capitalize(SetBidsRequestMap.BIDS), bid);

        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsSetBids(request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY, capitalize(SetBidsRequestMap.BIDS)));
    }

    @Test
    @Description("Неверный тип внутри массива Bids")
    public void invalidTypeInBidsArray() {
        JSONObject request = new JSONObject();
        request.put(capitalize(SetBidsRequestMap.BIDS), new Object[]{1});

        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsSetBids(request,
                new Api5Error(8000, Api5ErrorDetailsJava.INVALID_VALUE,
                        capitalize(SetBidsRequestMap.BIDS)));
    }

    @Test
    @Description("Не целое число в id")
    public void notIntegerInId() {
        JSONObject bid = new JSONObject();
        bid.put(capitalize(SetBidsItemMap.BID), 10_000_000L);
        bid.put(capitalize(SetBidsItemMap.ID), 1.7);

        JSONObject request = new JSONObject();
        request.put(capitalize(SetBidsRequestMap.BIDS), new Object[]{bid});

        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsSetBids(request,
                new Api5Error(8000, Api5ErrorDetailsJava.INVALID_VALUE,
                        path(capitalize(SetBidsRequestMap.BIDS), capitalize(SetBidsItemMap.ID))));
    }
}
