package ru.yandex.autotests.directapi.dynamictextadtargets.setbids;

import java.util.Arrays;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SetBidsItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SetBidsRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.general.SetBidsExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 26.11.15.
 * https://st.yandex-team.ru/TESTIRT-7700
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.SET_BIDS)
@Description("Неположительные значения для ставок")
@RunWith(Parameterized.class)
public class SetBidsNotPositiveBidTest {

    private static final String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT;
    private static final Currency CURRENCY = Currency.RUB;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public Long bid;

    @Parameterized.Parameters(name = "Ставка = {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {0L},
                {-1L},
        });
    }

    private static long webpageId;

    @BeforeClass
    public static void prepareData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        Long campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);

        webpageId = api.userSteps.dynamicTextAdTargetsSteps().addWebpage(new WebpageAddItemMap()
                .defaultWebpage(adGroupId).withBid(20_000_000L));
    }

    @Test
    public void invalidValueInBid() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnSetBids(new SetBidsRequestMap()
                        .withBids(new SetBidsItemMap()
                                .withId(webpageId)
                                .withBid(bid)),
                SetBidsExpectedResult.errors(new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_LESS,
                        capitalize(SetBidsItemMap.BID), MoneyCurrency.get(CURRENCY).getNamePluralI(api.locale()),
                        MoneyCurrency.get(CURRENCY).getLongMinPrice().longValue())));
    }
}
