package ru.yandex.autotests.directapi.dynamictextadtargets.setbids;

import java.util.Arrays;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SetBidsItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SetBidsRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.general.SetBidsExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 26.11.15.
 * https://st.yandex-team.ru/TESTIRT-7700
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.SET_BIDS)
@Description("Проверка прав для ролей")
@RunWith(Parameterized.class)
public class SetBidsRolesTest {

    @ClassRule
    public static final ApiSteps api = new ApiSteps();

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @SuppressWarnings("DefaultAnnotationParam")
    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String loginToCreateWebpage;

    @Parameterized.Parameter(2)
    public String operatorLogin;

    @Parameterized.Parameter(3)
    public String login;

    @Parameterized.Parameter(4)
    public SetBidsExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList((Object[][]) new Object[][]{
                {"Установка ставки от имени менеджера", Logins.MANAGER_DEFAULT,
                        Logins.MANAGER_DEFAULT, DynamicTextAdTargetsLogins.SERV_CLIENT,
                        SetBidsExpectedResult.successWithId()},

                {"Установка ставки от имени вешальщика", DynamicTextAdTargetsLogins.SINGLE_CLIENT,
                        Logins.PLACER, DynamicTextAdTargetsLogins.SINGLE_CLIENT,
                        SetBidsExpectedResult.successWithId()},

                {"Установка ставки от имени суппорта", DynamicTextAdTargetsLogins.SINGLE_CLIENT,
                        Logins.SUPPORT, DynamicTextAdTargetsLogins.SINGLE_CLIENT,
                        SetBidsExpectedResult.successWithId()},

                {"Установка ставки от имени супера", DynamicTextAdTargetsLogins.SUPER_LOGIN,
                        Logins.SUPER_LOGIN, DynamicTextAdTargetsLogins.SINGLE_CLIENT,
                        SetBidsExpectedResult.successWithId()},

                {"Установка ставки от имени медиапланера", DynamicTextAdTargetsLogins.SINGLE_CLIENT,
                        Logins.MEDIA, DynamicTextAdTargetsLogins.SINGLE_CLIENT,
                        SetBidsExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE))},

                {"Установка ставки от имени суперридера", DynamicTextAdTargetsLogins.SINGLE_CLIENT,
                        Logins.SUPER_READER, DynamicTextAdTargetsLogins.SINGLE_CLIENT,
                        SetBidsExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE))},

                {"Установка ставки от имени обычного клиента", DynamicTextAdTargetsLogins.SINGLE_CLIENT,
                        DynamicTextAdTargetsLogins.SINGLE_CLIENT, DynamicTextAdTargetsLogins.SINGLE_CLIENT,
                        SetBidsExpectedResult.successWithId()},

                {"Установка ставки от имени представителя клиента", DynamicTextAdTargetsLogins.SINGLE_CLIENT,
                        DynamicTextAdTargetsLogins.SINGLE_CLIENT_REP, DynamicTextAdTargetsLogins.SINGLE_CLIENT,
                        SetBidsExpectedResult.successWithId()},

                {"Установка ставки от имени агенства", DynamicTextAdTargetsLogins.AGENCY,
                        DynamicTextAdTargetsLogins.AGENCY, DynamicTextAdTargetsLogins.SUBCLIENT,
                        SetBidsExpectedResult.successWithId()},

                {"Установка ставки от имени представителя агенства", DynamicTextAdTargetsLogins.AGENCY,
                        DynamicTextAdTargetsLogins.AGENCY_REP, DynamicTextAdTargetsLogins.SUBCLIENT,
                        SetBidsExpectedResult.successWithId()},
        });
    }

    private Long webpageId;

    @Before
    @Step("Подготовка данных для теста")
    public void createWebpage() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(operatorLogin);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(loginToCreateWebpage);

        api.as(loginToCreateWebpage);
        Long campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign(login);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId, login);
        webpageId = api.userSteps.dynamicTextAdTargetsSteps().addWebpage(new WebpageAddItemMap()
                .defaultWebpage(adGroupId)
                .withBid(20_000_000L), login);
    }

    @Test
    public void setBidsWithRole() {
        api.as(operatorLogin);
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap().withBids(new SetBidsItemMap()
                        .withId(webpageId)
                        .withBid(25_000_000L)),
                login,
                new SetBidsExpectedResult[]{expectedResult});
    }
}
