package ru.yandex.autotests.directapi.dynamictextadtargets.setbids;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SetBidsItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SetBidsRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.SetBidsExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 26.11.15.
 * https://st.yandex-team.ru/TESTIRT-7700
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.SET_BIDS)
@Description("Вызов метода SetBids по протоколу SOAP")
public class SetBidsSoapTest {

    private static final String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignId;
    private static Long adGroupId;
    private static Long webpageId;

    @BeforeClass
    public static void createWebpage() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        webpageId = api.userSteps.dynamicTextAdTargetsSteps().addWebpage(new WebpageAddItemMap()
                .defaultWebpage(adGroupId)
                .withBid(20_000_000L));
        api.protocol(ProtocolType.SOAP);
    }

    @Test
    @Description("Установка по идентификатору webpage")
    public void setBidsWithId() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap().withBids(new SetBidsItemMap()
                        .withId(webpageId)
                        .withBid(25_000_000L)),
                SetBidsExpectedResult.successWithId());
    }

    @Test
    @Description("Установка по идентификатору группу")
    public void setBidsWithAdGroupId() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap().withBids(new SetBidsItemMap()
                        .withAdGroupId(adGroupId)
                        .withBid(25_000_000L)),
                SetBidsExpectedResult.successWithAdGroupId());
    }

    @Test
    @Description("Установка по идентификатору кампании")
    public void setBidsWithCampaignId() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap().withBids(new SetBidsItemMap()
                        .withCampaignId(campaignId)
                        .withBid(25_000_000L)),
                SetBidsExpectedResult.successWithCampaignId());
    }
}
