package ru.yandex.autotests.directapi.dynamictextadtargets.suspend;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SuspendRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by gerdler on 12.08.16.
 * https://st.yandex-team.ru/TESTIRT-10036
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-55156")
@Features(DynamicTextAdTargetsFeatures.RESUME)
@Description("Проверяем получение ошибки при попытке приостановить фильтр в ДО-группе с фидом")
public class SuspendDynamicTextFeedFilterTest {
    private static final String CLIENT = DynamicTextAdTargetsLogins.SINGLE_CLIENT_RESUME;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long dynamicTextFeedFilterId;

    @BeforeClass
    public static void initTest() {
        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        dynamicTextFeedFilterId = api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        int shard = api.userSteps.clientFakeSteps().getUserShard(CLIENT);
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        Long feedId = jooqDbSteps.feedsSteps().createDefaultFeed(User.get(CLIENT).getClientID());
        jooqDbSteps.adGroupsSteps().convertAdgroupDynamicToDynamicByFeed(pid, feedId);
    }

    @Before
    public void clearSpentUnits(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    public void suspendDynamicTextFeedFilter() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnSuspend(
                new SuspendRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(dynamicTextFeedFilterId)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.WEBPAGE_NOT_FOUND))
        );
    }
}
