package ru.yandex.autotests.directapi.dynamictextadtargets.suspend;

import org.apache.commons.lang3.ArrayUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SuspendRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlApi5Error;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 13.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.SUSPEND)
@Description("Попытка остановки условий нацеливаний, число которых больше максимального")
public class SuspendIdsLengthRestrictionNegativeTest {

    private static final String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT_SUSPEND;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Остановить условия нацеливания, число которых больше " + IdsCriteriaMap.IDS_MAX_LENGTH + " за один запрос")
    public void suspendGreaterThanMaxWebpagesWithOneRequest() {
        Long[] webpagesIDs = ArrayUtils.toObject(new long[IdsCriteriaMap.IDS_MAX_LENGTH + 1]);

        Api5Error javaError =
                new Api5Error(4001, Api5ErrorDetails.ALLOW_SUSPEND_NO_MORE_WEBPAGES, IdsCriteriaMap.IDS_MAX_LENGTH);
        javaError.getFaultInfo().setErrorDetail("Разрeшено останавливать не более 10000 условий в запросе");

        JavaOrPerlApi5Error bothError = JavaOrPerlApi5Error
                .java(javaError)
                .perl(new Api5Error(4001, Api5ErrorDetails.ALLOW_SUSPEND_NO_MORE_WEBPAGES,
                        IdsCriteriaMap.IDS_MAX_LENGTH));
        // Разделение на две ошибки нужно убрать, когда приедут переводы в DIRECT-93168

        api.as(LOGIN).userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsSuspend(
                new SuspendRequestMap()
                        .withSelectionCriteria(
                                new IdsCriteriaMap()
                                        .withIds(webpagesIDs)),
                bothError);
    }
}
